/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.util.Map;
import org.gradle.api.internal.changedetection.FileCollectionSnapshot;
import org.gradle.util.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapMergeChangeListener<K, V>
implements ChangeListener<Map.Entry<K, V>> {
    private final ChangeListener<FileCollectionSnapshot.Merge> listener;
    private final Map<K, V> newSnapshots;

    public MapMergeChangeListener(ChangeListener<FileCollectionSnapshot.Merge> changeListener, Map<K, V> map) {
        this.listener = changeListener;
        this.newSnapshots = map;
    }

    @Override
    public void added(Map.Entry<K, V> entry) {
        DefaultMerge defaultMerge = new DefaultMerge();
        this.listener.added(defaultMerge);
        if (!defaultMerge.isIgnore()) {
            this.newSnapshots.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void removed(Map.Entry<K, V> entry) {
        DefaultMerge defaultMerge = new DefaultMerge();
        this.listener.removed(defaultMerge);
        if (!defaultMerge.isIgnore()) {
            this.newSnapshots.remove(entry.getKey());
        }
    }

    @Override
    public void changed(Map.Entry<K, V> entry) {
        DefaultMerge defaultMerge = new DefaultMerge();
        this.listener.changed(defaultMerge);
        if (!defaultMerge.isIgnore()) {
            this.newSnapshots.put(entry.getKey(), entry.getValue());
        }
    }

    private static class DefaultMerge
    implements FileCollectionSnapshot.Merge {
        private boolean ignore;

        private DefaultMerge() {
        }

        public boolean isIgnore() {
            return this.ignore;
        }

        public void ignore() {
            this.ignore = true;
        }
    }
}

