/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskExecution;
import org.gradle.api.internal.changedetection.UpToDateRule;
import org.gradle.util.ChangeListener;
import org.gradle.util.DiffUtil;

public class InputPropertiesChangedUpToDateRule
implements UpToDateRule {
    public UpToDateRule.TaskUpToDateState create(final TaskInternal taskInternal, final TaskExecution taskExecution, TaskExecution taskExecution2) {
        final HashMap<String, Object> hashMap = new HashMap<String, Object>(taskInternal.getInputs().getProperties());
        taskExecution2.setInputProperties(hashMap);
        return new UpToDateRule.TaskUpToDateState(){

            @Override
            public void checkUpToDate(final Collection<String> collection) {
                DiffUtil.diff(hashMap, taskExecution.getInputProperties(), new ChangeListener<Map.Entry<String, Object>>(){

                    @Override
                    public void added(Map.Entry<String, Object> entry) {
                        collection.add(String.format("Input property '%s' has been added for %s", entry.getKey(), taskInternal));
                    }

                    @Override
                    public void removed(Map.Entry<String, Object> entry) {
                        collection.add(String.format("Input property '%s' has been removed for %s", entry.getKey(), taskInternal));
                    }

                    @Override
                    public void changed(Map.Entry<String, Object> entry) {
                        collection.add(String.format("Value of input property '%s' has changed for %s", entry.getKey(), taskInternal));
                    }
                });
            }

            @Override
            public void snapshotAfterTask() {
            }
        };
    }
}

