/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.File;
import java.util.Collection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.FileSnapshotter;
import org.gradle.api.internal.changedetection.TaskExecution;
import org.gradle.api.internal.changedetection.UpToDateRule;
import org.gradle.util.ChangeListener;

public class InputFilesChangedUpToDateRule
implements UpToDateRule {
    private final FileSnapshotter inputFilesSnapshotter;

    public InputFilesChangedUpToDateRule(FileSnapshotter fileSnapshotter) {
        this.inputFilesSnapshotter = fileSnapshotter;
    }

    public UpToDateRule.TaskUpToDateState create(final TaskInternal taskInternal, final TaskExecution taskExecution, final TaskExecution taskExecution2) {
        final FileCollectionSnapshot fileCollectionSnapshot = this.inputFilesSnapshotter.snapshot(taskInternal.getInputs().getFiles());
        return new UpToDateRule.TaskUpToDateState(){

            @Override
            public void checkUpToDate(final Collection<String> collection) {
                if (taskExecution.getInputFilesSnapshot() == null) {
                    collection.add(String.format("Input file history is not available for %s.", taskInternal));
                    return;
                }
                fileCollectionSnapshot.changesSince(taskExecution.getInputFilesSnapshot(), new ChangeListener<File>(){

                    @Override
                    public void added(File file) {
                        collection.add(String.format("Input file %s for %s added.", file, taskInternal));
                    }

                    @Override
                    public void removed(File file) {
                        collection.add(String.format("Input file %s for %s removed.", file, taskInternal));
                    }

                    @Override
                    public void changed(File file) {
                        collection.add(String.format("Input file %s for %s has changed.", file, taskInternal));
                    }
                });
            }

            @Override
            public void snapshotAfterTask() {
                taskExecution2.setInputFilesSnapshot(fileCollectionSnapshot);
            }
        };
    }
}

