/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryIndexedCache<K, V>
implements PersistentIndexedCache<K, V> {
    Map<Object, byte[]> entries = new HashMap<Object, byte[]>();

    @Override
    public V get(K k) {
        byte[] byArray = this.entries.get(k);
        if (byArray == null) {
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return (V)new ObjectInputStream(byteArrayInputStream).readObject();
        }
        catch (Exception exception) {
            throw UncheckedException.throwAsUncheckedException((Throwable)exception);
        }
    }

    @Override
    public void put(K k, V v) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(v);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        this.entries.put(k, byteArrayOutputStream.toByteArray());
    }

    @Override
    public void remove(K k) {
        this.entries.remove(k);
    }
}

