/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.FileCacheListener;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;

public class FileCacheBroadcastTaskArtifactStateRepository
implements TaskArtifactStateRepository {
    private final TaskArtifactStateRepository repository;
    private final FileCacheListener listener;

    public FileCacheBroadcastTaskArtifactStateRepository(TaskArtifactStateRepository taskArtifactStateRepository, FileCacheListener fileCacheListener) {
        this.repository = taskArtifactStateRepository;
        this.listener = fileCacheListener;
    }

    public TaskArtifactState getStateFor(final TaskInternal taskInternal) {
        final TaskArtifactState taskArtifactState = this.repository.getStateFor(taskInternal);
        return new TaskArtifactState(){

            public boolean isUpToDate() {
                FileCacheBroadcastTaskArtifactStateRepository.this.listener.cacheable(taskInternal.getInputs().getFiles());
                FileCacheBroadcastTaskArtifactStateRepository.this.listener.cacheable(taskInternal.getOutputs().getFiles());
                return taskArtifactState.isUpToDate();
            }

            public void beforeTask() {
                if (taskInternal.getOutputs().getHasOutput()) {
                    FileCacheBroadcastTaskArtifactStateRepository.this.listener.invalidate(taskInternal.getOutputs().getFiles());
                } else {
                    FileCacheBroadcastTaskArtifactStateRepository.this.listener.invalidateAll();
                }
                taskArtifactState.beforeTask();
            }

            public void afterTask() {
                FileCacheBroadcastTaskArtifactStateRepository.this.listener.cacheable(taskInternal.getOutputs().getFiles());
                taskArtifactState.afterTask();
            }

            public void finished() {
                taskArtifactState.finished();
            }

            public TaskExecutionHistory getExecutionHistory() {
                return taskArtifactState.getExecutionHistory();
            }
        };
    }
}

