/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.File;
import org.gradle.api.internal.changedetection.TaskArtifactStateCacheAccess;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.Serializer;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.internal.Factory;
import org.gradle.listener.LazyCreationProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskArtifactStateCacheAccess
implements TaskArtifactStateCacheAccess {
    private final Gradle gradle;
    private final CacheRepository cacheRepository;
    private PersistentCache cache;

    public DefaultTaskArtifactStateCacheAccess(Gradle gradle, CacheRepository cacheRepository) {
        this.gradle = gradle;
        this.cacheRepository = cacheRepository;
    }

    private PersistentCache getCache() {
        if (this.cache == null) {
            this.cache = (PersistentCache)this.cacheRepository.cache("taskArtifacts").forObject(this.gradle).withDisplayName("task artifact state cache").withLockMode(FileLockManager.LockMode.Exclusive).open();
        }
        return this.cache;
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(final String string, final Class<K> clazz, final Class<V> clazz2) {
        Factory<PersistentIndexedCache> factory = new Factory<PersistentIndexedCache>(){

            public PersistentIndexedCache create() {
                return DefaultTaskArtifactStateCacheAccess.this.getCache().createCache(DefaultTaskArtifactStateCacheAccess.this.cacheFile(string), clazz, clazz2);
            }
        };
        return new LazyCreationProxy<PersistentIndexedCache>(PersistentIndexedCache.class, factory).getSource();
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(final String string, final Class<K> clazz, Class<V> clazz2, final Serializer<V> serializer) {
        Factory<PersistentIndexedCache> factory = new Factory<PersistentIndexedCache>(){

            public PersistentIndexedCache create() {
                return DefaultTaskArtifactStateCacheAccess.this.getCache().createCache(DefaultTaskArtifactStateCacheAccess.this.cacheFile(string), clazz, serializer);
            }
        };
        return new LazyCreationProxy<PersistentIndexedCache>(PersistentIndexedCache.class, factory).getSource();
    }

    private File cacheFile(String string) {
        return new File(this.getCache().getBaseDir(), string + ".bin");
    }

    @Override
    public <T> T useCache(String string, Factory<? extends T> factory) {
        return this.getCache().useCache(string, factory);
    }

    @Override
    public void useCache(String string, Runnable runnable) {
        this.getCache().useCache(string, runnable);
    }

    @Override
    public void longRunningOperation(String string, Runnable runnable) {
        this.getCache().longRunningOperation(string, runnable);
    }
}

