/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.changedetection.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.FileSnapshotter;
import org.gradle.api.internal.changedetection.Hasher;
import org.gradle.api.internal.changedetection.MapMergeChangeListener;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.util.ChangeListener;
import org.gradle.util.NoOpChangeListener;

public class DefaultFileSnapshotter
implements FileSnapshotter {
    private final Hasher hasher;

    public DefaultFileSnapshotter(Hasher hasher) {
        this.hasher = hasher;
    }

    public FileCollectionSnapshot emptySnapshot() {
        return new FileCollectionSnapshotImpl(new HashMap<String, FileSnapshot>());
    }

    public FileCollectionSnapshot snapshot(FileCollection fileCollection) {
        HashMap<String, FileSnapshot> hashMap = new HashMap<String, FileSnapshot>();
        for (File file : fileCollection.getAsFileTree()) {
            if (file.isFile()) {
                hashMap.put(file.getAbsolutePath(), new FileHashSnapshot(this.hasher.hash(file)));
                continue;
            }
            if (file.isDirectory()) {
                hashMap.put(file.getAbsolutePath(), new DirSnapshot());
                continue;
            }
            hashMap.put(file.getAbsolutePath(), new MissingFileSnapshot());
        }
        return new FileCollectionSnapshotImpl(hashMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileCollectionSnapshotImpl
    implements FileCollectionSnapshot {
        private final Map<String, FileSnapshot> snapshots;

        public FileCollectionSnapshotImpl(Map<String, FileSnapshot> map) {
            this.snapshots = map;
        }

        @Override
        public FileCollection getFiles() {
            ArrayList<File> arrayList = new ArrayList<File>();
            for (Map.Entry<String, FileSnapshot> entry : this.snapshots.entrySet()) {
                if (!(entry.getValue() instanceof FileHashSnapshot)) continue;
                arrayList.add(new File(entry.getKey()));
            }
            return new SimpleFileCollection(arrayList);
        }

        @Override
        public void changesSince(FileCollectionSnapshot fileCollectionSnapshot, final ChangeListener<File> changeListener) {
            FileCollectionSnapshotImpl fileCollectionSnapshotImpl = (FileCollectionSnapshotImpl)fileCollectionSnapshot;
            this.diff(this.snapshots, fileCollectionSnapshotImpl.snapshots, new ChangeListener<Map.Entry<String, FileSnapshot>>(){

                @Override
                public void added(Map.Entry<String, FileSnapshot> entry) {
                    changeListener.added(new File(entry.getKey()));
                }

                @Override
                public void removed(Map.Entry<String, FileSnapshot> entry) {
                    changeListener.removed(new File(entry.getKey()));
                }

                @Override
                public void changed(Map.Entry<String, FileSnapshot> entry) {
                    changeListener.changed(new File(entry.getKey()));
                }
            });
        }

        private void diff(Map<String, FileSnapshot> map, Map<String, FileSnapshot> map2, ChangeListener<Map.Entry<String, FileSnapshot>> changeListener) {
            HashMap<String, FileSnapshot> hashMap = new HashMap<String, FileSnapshot>(map2);
            for (Map.Entry<String, FileSnapshot> entry : map.entrySet()) {
                FileSnapshot fileSnapshot = (FileSnapshot)hashMap.remove(entry.getKey());
                if (fileSnapshot == null) {
                    changeListener.added(entry);
                    continue;
                }
                if (entry.getValue().isUpToDate(fileSnapshot)) continue;
                changeListener.changed(entry);
            }
            for (Map.Entry<String, FileSnapshot> entry : hashMap.entrySet()) {
                changeListener.removed(entry);
            }
        }

        @Override
        public FileCollectionSnapshot.Diff changesSince(FileCollectionSnapshot fileCollectionSnapshot) {
            final FileCollectionSnapshotImpl fileCollectionSnapshotImpl = (FileCollectionSnapshotImpl)fileCollectionSnapshot;
            return new FileCollectionSnapshot.Diff(){

                @Override
                public FileCollectionSnapshot applyTo(FileCollectionSnapshot fileCollectionSnapshot) {
                    return this.applyTo(fileCollectionSnapshot, new NoOpChangeListener<FileCollectionSnapshot.Merge>());
                }

                @Override
                public FileCollectionSnapshot applyTo(FileCollectionSnapshot fileCollectionSnapshot, ChangeListener<FileCollectionSnapshot.Merge> changeListener) {
                    FileCollectionSnapshotImpl fileCollectionSnapshotImpl2 = (FileCollectionSnapshotImpl)fileCollectionSnapshot;
                    HashMap<String, FileSnapshot> hashMap = new HashMap<String, FileSnapshot>(fileCollectionSnapshotImpl2.snapshots);
                    FileCollectionSnapshotImpl.this.diff(FileCollectionSnapshotImpl.this.snapshots, fileCollectionSnapshotImpl.snapshots, new MapMergeChangeListener(changeListener, hashMap));
                    return new FileCollectionSnapshotImpl(hashMap);
                }
            };
        }
    }

    private static class MissingFileSnapshot
    implements FileSnapshot {
        private MissingFileSnapshot() {
        }

        public boolean isUpToDate(FileSnapshot fileSnapshot) {
            return fileSnapshot instanceof MissingFileSnapshot;
        }
    }

    private static class DirSnapshot
    implements FileSnapshot {
        private DirSnapshot() {
        }

        public boolean isUpToDate(FileSnapshot fileSnapshot) {
            return fileSnapshot instanceof DirSnapshot;
        }
    }

    private static class FileHashSnapshot
    implements FileSnapshot {
        private final byte[] hash;

        public FileHashSnapshot(byte[] byArray) {
            this.hash = byArray;
        }

        public boolean isUpToDate(FileSnapshot fileSnapshot) {
            if (!(fileSnapshot instanceof FileHashSnapshot)) {
                return false;
            }
            FileHashSnapshot fileHashSnapshot = (FileHashSnapshot)fileSnapshot;
            return Arrays.equals(this.hash, fileHashSnapshot.hash);
        }

        public String toString() {
            return new BigInteger(1, this.hash).toString(16);
        }
    }

    private static interface FileSnapshot
    extends Serializable {
        public boolean isUpToDate(FileSnapshot var1);
    }
}

