/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskExecution;
import org.gradle.api.internal.changedetection.UpToDateRule;

public class CompositeUpToDateRule
implements UpToDateRule {
    private final List<UpToDateRule> rules;

    public CompositeUpToDateRule(UpToDateRule ... upToDateRuleArray) {
        this.rules = new ArrayList<UpToDateRule>(Arrays.asList(upToDateRuleArray));
    }

    public UpToDateRule.TaskUpToDateState create(TaskInternal taskInternal, TaskExecution taskExecution, TaskExecution taskExecution2) {
        final ArrayList<UpToDateRule.TaskUpToDateState> arrayList = new ArrayList<UpToDateRule.TaskUpToDateState>();
        for (UpToDateRule upToDateRule : this.rules) {
            arrayList.add(upToDateRule.create(taskInternal, taskExecution, taskExecution2));
        }
        return new UpToDateRule.TaskUpToDateState(){

            @Override
            public void checkUpToDate(Collection<String> collection) {
                for (int i = 0; collection.isEmpty() && i < arrayList.size(); ++i) {
                    UpToDateRule.TaskUpToDateState taskUpToDateState = (UpToDateRule.TaskUpToDateState)arrayList.get(i);
                    taskUpToDateState.checkUpToDate(collection);
                }
            }

            @Override
            public void snapshotAfterTask() {
                for (UpToDateRule.TaskUpToDateState taskUpToDateState : arrayList) {
                    taskUpToDateState.snapshotAfterTask();
                }
            }
        };
    }
}

