/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.gradle.api.internal.changedetection.Hasher;
import org.gradle.api.internal.changedetection.TaskArtifactStateCacheAccess;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.Serializer;

public class CachingHasher
implements Hasher {
    private final PersistentIndexedCache<File, FileInfo> cache;
    private final Hasher hasher;
    private long timestamp;

    public CachingHasher(Hasher hasher, TaskArtifactStateCacheAccess taskArtifactStateCacheAccess) {
        this.hasher = hasher;
        this.cache = taskArtifactStateCacheAccess.createCache("fileHashes", File.class, FileInfo.class, new FileInfoSerializer());
    }

    public byte[] hash(File file) {
        FileInfo fileInfo = this.cache.get(file);
        long l = file.length();
        this.timestamp = file.lastModified();
        if (fileInfo != null && l == fileInfo.length && this.timestamp == fileInfo.timestamp) {
            return fileInfo.hash;
        }
        byte[] byArray = this.hasher.hash(file);
        this.cache.put(file, new FileInfo(byArray, l, this.timestamp));
        return byArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileInfoSerializer
    implements Serializer<FileInfo> {
        private FileInfoSerializer() {
        }

        @Override
        public FileInfo read(InputStream inputStream) throws Exception {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readInt();
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray);
            long l = dataInputStream.readLong();
            long l2 = dataInputStream.readLong();
            return new FileInfo(byArray, l2, l);
        }

        @Override
        public void write(OutputStream outputStream, FileInfo fileInfo) throws Exception {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeInt(fileInfo.hash.length);
            dataOutputStream.write(fileInfo.hash);
            dataOutputStream.writeLong(fileInfo.timestamp);
            dataOutputStream.writeLong(fileInfo.length);
            dataOutputStream.flush();
        }
    }

    public static class FileInfo
    implements Serializable {
        private final byte[] hash;
        private final long timestamp;
        private final long length;

        public FileInfo(byte[] byArray, long l, long l2) {
            this.hash = byArray;
            this.length = l;
            this.timestamp = l2;
        }
    }
}

