/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.FileSnapshotRepository;
import org.gradle.api.internal.changedetection.TaskArtifactStateCacheAccess;
import org.gradle.api.internal.changedetection.TaskExecution;
import org.gradle.api.internal.changedetection.TaskHistoryRepository;
import org.gradle.cache.DefaultSerializer;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheBackedTaskHistoryRepository
implements TaskHistoryRepository {
    private final TaskArtifactStateCacheAccess cacheAccess;
    private final FileSnapshotRepository snapshotRepository;
    private final PersistentIndexedCache<String, TaskHistory> taskHistoryCache;
    private final DefaultSerializer<TaskHistory> serializer = new DefaultSerializer();

    public CacheBackedTaskHistoryRepository(TaskArtifactStateCacheAccess taskArtifactStateCacheAccess, FileSnapshotRepository fileSnapshotRepository) {
        this.cacheAccess = taskArtifactStateCacheAccess;
        this.snapshotRepository = fileSnapshotRepository;
        this.taskHistoryCache = taskArtifactStateCacheAccess.createCache("taskArtifacts", String.class, TaskHistory.class, this.serializer);
    }

    @Override
    public TaskHistoryRepository.History getHistory(final TaskInternal taskInternal) {
        final TaskHistory taskHistory = this.loadHistory(taskInternal);
        final LazyTaskExecution lazyTaskExecution = new LazyTaskExecution();
        lazyTaskExecution.snapshotRepository = this.snapshotRepository;
        lazyTaskExecution.cacheAccess = this.cacheAccess;
        lazyTaskExecution.setOutputFiles(CacheBackedTaskHistoryRepository.outputFiles(taskInternal));
        final LazyTaskExecution lazyTaskExecution2 = this.findPreviousExecution(lazyTaskExecution, taskHistory);
        if (lazyTaskExecution2 != null) {
            lazyTaskExecution2.snapshotRepository = this.snapshotRepository;
            lazyTaskExecution2.cacheAccess = this.cacheAccess;
        }
        taskHistory.configurations.add(0, lazyTaskExecution);
        return new TaskHistoryRepository.History(){

            public TaskExecution getPreviousExecution() {
                return lazyTaskExecution2;
            }

            public TaskExecution getCurrentExecution() {
                return lazyTaskExecution;
            }

            public void update() {
                if (lazyTaskExecution.inputFilesSnapshotId == null && lazyTaskExecution.inputFilesSnapshot != null) {
                    lazyTaskExecution.inputFilesSnapshotId = CacheBackedTaskHistoryRepository.this.snapshotRepository.add(lazyTaskExecution.inputFilesSnapshot);
                }
                if (lazyTaskExecution.outputFilesSnapshotId == null && lazyTaskExecution.outputFilesSnapshot != null) {
                    lazyTaskExecution.outputFilesSnapshotId = CacheBackedTaskHistoryRepository.this.snapshotRepository.add(lazyTaskExecution.outputFilesSnapshot);
                }
                while (taskHistory.configurations.size() > 3) {
                    LazyTaskExecution lazyTaskExecution3 = (LazyTaskExecution)taskHistory.configurations.remove(taskHistory.configurations.size() - 1);
                    if (lazyTaskExecution3.inputFilesSnapshotId != null) {
                        CacheBackedTaskHistoryRepository.this.snapshotRepository.remove(lazyTaskExecution3.inputFilesSnapshotId);
                    }
                    if (lazyTaskExecution3.outputFilesSnapshotId == null) continue;
                    CacheBackedTaskHistoryRepository.this.snapshotRepository.remove(lazyTaskExecution3.outputFilesSnapshotId);
                }
                CacheBackedTaskHistoryRepository.this.taskHistoryCache.put(taskInternal.getPath(), taskHistory);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskHistory loadHistory(TaskInternal taskInternal) {
        ClassLoader classLoader = this.serializer.getClassLoader();
        this.serializer.setClassLoader(taskInternal.getClass().getClassLoader());
        try {
            TaskHistory taskHistory = this.taskHistoryCache.get(taskInternal.getPath());
            TaskHistory taskHistory2 = taskHistory == null ? new TaskHistory() : taskHistory;
            return taskHistory2;
        }
        finally {
            this.serializer.setClassLoader(classLoader);
        }
    }

    private static Set<String> outputFiles(TaskInternal taskInternal) {
        HashSet<String> hashSet = new HashSet<String>();
        for (File file : taskInternal.getOutputs().getFiles()) {
            hashSet.add(file.getAbsolutePath());
        }
        return hashSet;
    }

    private LazyTaskExecution findPreviousExecution(TaskExecution taskExecution, TaskHistory taskHistory) {
        Set<String> set = taskExecution.getOutputFiles();
        LazyTaskExecution lazyTaskExecution = null;
        int n = 0;
        for (LazyTaskExecution lazyTaskExecution2 : taskHistory.configurations) {
            if (set.size() == 0 && lazyTaskExecution2.getOutputFiles().size() == 0) {
                lazyTaskExecution = lazyTaskExecution2;
                break;
            }
            HashSet<String> hashSet = new HashSet<String>(set);
            hashSet.retainAll(lazyTaskExecution2.getOutputFiles());
            if (hashSet.size() > n) {
                lazyTaskExecution = lazyTaskExecution2;
                n = hashSet.size();
            }
            if (n != set.size()) continue;
            break;
        }
        return lazyTaskExecution;
    }

    private static class LazyTaskExecution
    extends TaskExecution {
        private Long inputFilesSnapshotId;
        private Long outputFilesSnapshotId;
        private transient FileSnapshotRepository snapshotRepository;
        private transient FileCollectionSnapshot inputFilesSnapshot;
        private transient FileCollectionSnapshot outputFilesSnapshot;
        private transient TaskArtifactStateCacheAccess cacheAccess;

        private LazyTaskExecution() {
        }

        public FileCollectionSnapshot getInputFilesSnapshot() {
            if (this.inputFilesSnapshot == null) {
                this.inputFilesSnapshot = this.snapshotRepository.get(this.inputFilesSnapshotId);
            }
            return this.inputFilesSnapshot;
        }

        public void setInputFilesSnapshot(FileCollectionSnapshot fileCollectionSnapshot) {
            this.inputFilesSnapshot = fileCollectionSnapshot;
            this.inputFilesSnapshotId = null;
        }

        public FileCollectionSnapshot getOutputFilesSnapshot() {
            if (this.outputFilesSnapshot == null) {
                this.outputFilesSnapshot = this.cacheAccess.useCache("fetch output files", new Factory<FileCollectionSnapshot>(){

                    public FileCollectionSnapshot create() {
                        return LazyTaskExecution.this.snapshotRepository.get(LazyTaskExecution.this.outputFilesSnapshotId);
                    }
                });
            }
            return this.outputFilesSnapshot;
        }

        public void setOutputFilesSnapshot(FileCollectionSnapshot fileCollectionSnapshot) {
            this.outputFilesSnapshot = fileCollectionSnapshot;
            this.outputFilesSnapshotId = null;
        }
    }

    private static class TaskHistory
    implements Serializable {
        private static final int MAX_HISTORY_ENTRIES = 3;
        private final List<LazyTaskExecution> configurations = new ArrayList<LazyTaskExecution>();

        private TaskHistory() {
        }
    }
}

