/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.api.internal.artifacts.dsl.AbstractScriptTransformer;

public class TaskDefinitionScriptTransformer
extends AbstractScriptTransformer {
    protected int getPhase() {
        return 5;
    }

    public String getId() {
        return "tasks";
    }

    public void call(SourceUnit sourceUnit) throws CompilationFailedException {
        this.visitScriptCode(sourceUnit, (GroovyCodeVisitor)new TaskDefinitionTransformer());
    }

    private class TaskDefinitionTransformer
    extends CodeVisitorSupport {
        private TaskDefinitionTransformer() {
        }

        public void visitMethodCallExpression(MethodCallExpression methodCallExpression) {
            this.doVisitMethodCallExpression(methodCallExpression);
            super.visitMethodCallExpression(methodCallExpression);
        }

        private void doVisitMethodCallExpression(MethodCallExpression methodCallExpression) {
            if (!this.isInstanceMethod(methodCallExpression, "task")) {
                return;
            }
            ArgumentListExpression argumentListExpression = (ArgumentListExpression)methodCallExpression.getArguments();
            if (argumentListExpression.getExpressions().size() == 0 || argumentListExpression.getExpressions().size() > 3) {
                return;
            }
            if (argumentListExpression.getExpressions().size() > 1) {
                if (argumentListExpression.getExpression(0) instanceof MapExpression && argumentListExpression.getExpression(1) instanceof VariableExpression) {
                    this.transformVariableExpression(methodCallExpression, 1);
                } else if (argumentListExpression.getExpression(0) instanceof VariableExpression) {
                    this.transformVariableExpression(methodCallExpression, 0);
                }
                return;
            }
            Expression expression = argumentListExpression.getExpression(0);
            if (expression instanceof VariableExpression) {
                this.transformVariableExpression(methodCallExpression, 0);
            } else if (expression instanceof BinaryExpression) {
                this.transformBinaryExpression(methodCallExpression, (BinaryExpression)expression);
            } else if (expression instanceof MethodCallExpression) {
                this.maybeTransformNestedMethodCall((MethodCallExpression)expression, methodCallExpression);
            }
        }

        private void transformVariableExpression(MethodCallExpression methodCallExpression, int n) {
            ArgumentListExpression argumentListExpression = (ArgumentListExpression)methodCallExpression.getArguments();
            VariableExpression variableExpression = (VariableExpression)argumentListExpression.getExpression(n);
            if (!this.isDynamicVar((Expression)variableExpression)) {
                return;
            }
            String string = variableExpression.getText();
            methodCallExpression.setMethod((Expression)new ConstantExpression((Object)"task"));
            argumentListExpression.getExpressions().set(n, new ConstantExpression((Object)string));
        }

        private void transformBinaryExpression(MethodCallExpression methodCallExpression, BinaryExpression binaryExpression) {
            if (binaryExpression.getLeftExpression() instanceof VariableExpression || binaryExpression.getLeftExpression() instanceof GStringExpression || binaryExpression.getLeftExpression() instanceof ConstantExpression) {
                methodCallExpression.setMethod((Expression)new ConstantExpression((Object)"passThrough"));
                Object object = binaryExpression.getLeftExpression() instanceof VariableExpression ? new ConstantExpression((Object)binaryExpression.getLeftExpression().getText()) : binaryExpression.getLeftExpression();
                binaryExpression.setLeftExpression((Expression)new MethodCallExpression(methodCallExpression.getObjectExpression(), "task", object));
            } else if (binaryExpression.getLeftExpression() instanceof MethodCallExpression) {
                MethodCallExpression methodCallExpression2 = new MethodCallExpression(methodCallExpression.getObjectExpression(), "task", (Expression)new ArgumentListExpression());
                boolean bl = this.maybeTransformNestedMethodCall((MethodCallExpression)binaryExpression.getLeftExpression(), methodCallExpression2);
                if (bl) {
                    methodCallExpression.setMethod((Expression)new ConstantExpression((Object)"passThrough"));
                    binaryExpression.setLeftExpression((Expression)methodCallExpression2);
                }
            }
        }

        private boolean maybeTransformNestedMethodCall(MethodCallExpression methodCallExpression, MethodCallExpression methodCallExpression2) {
            TupleExpression tupleExpression;
            if (!this.isTaskIdentifier(methodCallExpression.getMethod()) || !TaskDefinitionScriptTransformer.this.targetIsThis(methodCallExpression)) {
                return false;
            }
            Expression expression = methodCallExpression.getMethod();
            Expression expression2 = null;
            List list = Collections.emptyList();
            if (methodCallExpression.getArguments() instanceof TupleExpression) {
                tupleExpression = (TupleExpression)methodCallExpression.getArguments();
                if (tupleExpression.getExpressions().size() == 2 && tupleExpression.getExpression(0) instanceof MapExpression && tupleExpression.getExpression(1) instanceof ClosureExpression) {
                    expression2 = tupleExpression.getExpression(0);
                    list = tupleExpression.getExpressions().subList(1, tupleExpression.getExpressions().size());
                } else if (tupleExpression.getExpressions().size() == 1 && tupleExpression.getExpression(0) instanceof ClosureExpression) {
                    list = tupleExpression.getExpressions();
                } else if (tupleExpression.getExpressions().size() == 1 && tupleExpression.getExpression(0) instanceof NamedArgumentListExpression) {
                    expression2 = tupleExpression.getExpression(0);
                } else if (tupleExpression.getExpressions().size() != 0) {
                    return false;
                }
            }
            methodCallExpression2.setMethod((Expression)new ConstantExpression((Object)"task"));
            tupleExpression = (ArgumentListExpression)methodCallExpression2.getArguments();
            tupleExpression.getExpressions().clear();
            if (expression2 != null) {
                tupleExpression.addExpression(expression2);
            }
            tupleExpression.addExpression(expression);
            for (Expression expression3 : list) {
                tupleExpression.addExpression(expression3);
            }
            return true;
        }

        private boolean isInstanceMethod(MethodCallExpression methodCallExpression, String string) {
            boolean bl = TaskDefinitionScriptTransformer.this.isMethodOnThis(methodCallExpression, string);
            if (!bl) {
                return false;
            }
            return methodCallExpression.getArguments() instanceof ArgumentListExpression;
        }

        private boolean isTaskIdentifier(Expression expression) {
            return expression instanceof ConstantExpression || expression instanceof GStringExpression;
        }

        private boolean isDynamicVar(Expression expression) {
            if (!(expression instanceof VariableExpression)) {
                return false;
            }
            VariableExpression variableExpression = (VariableExpression)expression;
            return variableExpression.getAccessedVariable() instanceof DynamicVariable;
        }
    }
}

