/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.gradle.api.Action;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.Instantiator;
import org.gradle.api.internal.artifacts.DefaultArtifactRepositoryContainer;
import org.gradle.api.internal.artifacts.ResolverFactory;
import org.gradle.api.internal.artifacts.configurations.ResolverProvider;
import org.gradle.api.internal.artifacts.repositories.FixedResolverArtifactRepository;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositoryHandler
extends DefaultArtifactRepositoryContainer
implements RepositoryHandler,
ResolverProvider {
    public DefaultRepositoryHandler(ResolverFactory resolverFactory, Instantiator instantiator) {
        super(resolverFactory, instantiator);
    }

    @Override
    public FlatDirectoryArtifactRepository flatDir(Action<? super FlatDirectoryArtifactRepository> action) {
        return this.addRepository(this.getResolverFactory().createFlatDirRepository(), action, "flatDir");
    }

    @Override
    public FlatDirectoryArtifactRepository flatDir(Closure closure) {
        return this.addRepository(this.getResolverFactory().createFlatDirRepository(), closure, "flatDir");
    }

    @Override
    public FlatDirectoryArtifactRepository flatDir(Map<String, ?> map) {
        HashMap hashMap = new HashMap(map);
        if (hashMap.containsKey("dirs")) {
            hashMap.put("dirs", this.toList(hashMap.get("dirs")));
        }
        return this.addRepository(this.getResolverFactory().createFlatDirRepository(), hashMap, "flatDir");
    }

    @Override
    public MavenArtifactRepository mavenCentral() {
        return this.mavenCentral(Collections.emptyMap());
    }

    @Override
    public MavenArtifactRepository mavenCentral(Map<String, ?> map) {
        HashMap hashMap = new HashMap(map);
        if (hashMap.containsKey("urls")) {
            DeprecationLogger.nagUserWith("The 'urls' property of the RepositoryHandler.mavenCentral() method is deprecated and will be removed in a future version of Gradle. You should use the 'artifactUrls' property to define additional artifact locations.");
            List<Object> list = this.toList(hashMap.remove("urls"));
            hashMap.put("artifactUrls", list);
        }
        return this.addRepository(this.getResolverFactory().createMavenCentralRepository(), hashMap, "MavenRepo");
    }

    @Override
    public MavenArtifactRepository mavenLocal() {
        return this.addRepository(this.getResolverFactory().createMavenLocalRepository(), "MavenLocal");
    }

    @Override
    public DependencyResolver mavenRepo(Map<String, ?> map) {
        return this.mavenRepo(map, null);
    }

    @Override
    public DependencyResolver mavenRepo(Map<String, ?> map, Closure closure) {
        Object object;
        Object object2;
        HashMap hashMap = new HashMap(map);
        if (hashMap.containsKey("urls") && !(object2 = this.toList(hashMap.remove("urls"))).isEmpty()) {
            DeprecationLogger.nagUserWith("The 'urls' property of the RepositoryHandler.mavenRepo() method is deprecated and will be removed in a future version of Gradle. You should use the 'url' property to define the core maven repository & the 'artifactUrls' property to define any additional artifact locations.");
            hashMap.put("url", object2.get(0));
            object = object2.subList(1, object2.size());
            hashMap.put("artifactUrls", object);
        }
        object2 = this.getResolverFactory().createMavenRepository();
        ConfigureUtil.configureByMap(hashMap, object2);
        object = this.toResolver(DependencyResolver.class, (ArtifactRepository)object2);
        ConfigureUtil.configure(closure, object);
        this.addRepository(new FixedResolverArtifactRepository((DependencyResolver)object), "maven");
        return object;
    }

    private List<Object> toList(Object object) {
        if (object instanceof List) {
            return (List)object;
        }
        if (object instanceof Iterable) {
            return Lists.newArrayList((Iterable)((Iterable)object));
        }
        return Collections.singletonList(object);
    }

    @Override
    public MavenArtifactRepository maven(Action<? super MavenArtifactRepository> action) {
        return this.addRepository(this.getResolverFactory().createMavenRepository(), action, "maven");
    }

    @Override
    public MavenArtifactRepository maven(Closure closure) {
        return this.addRepository(this.getResolverFactory().createMavenRepository(), closure, "maven");
    }

    @Override
    public IvyArtifactRepository ivy(Action<? super IvyArtifactRepository> action) {
        return this.addRepository(this.getResolverFactory().createIvyRepository(), action, "ivy");
    }

    @Override
    public IvyArtifactRepository ivy(Closure closure) {
        return this.addRepository(this.getResolverFactory().createIvyRepository(), closure, "ivy");
    }
}

