/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.api.internal.artifacts.dsl.AbstractScriptTransformer;
import org.gradle.api.specs.NotSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClasspathScriptTransformer
extends AbstractScriptTransformer {
    protected abstract String getScriptMethodName();

    @Override
    protected int getPhase() {
        return 3;
    }

    public void call(SourceUnit sourceUnit) throws CompilationFailedException {
        Object object;
        Object object2;
        ImportNode importNode2;
        Spec<Statement> spec = this.isScriptBlock();
        this.filterStatements(sourceUnit, spec);
        for (ImportNode importNode2 : sourceUnit.getAST().getImports()) {
            if (this.isVisible(sourceUnit, importNode2.getClassName())) continue;
            try {
                object2 = ModuleNode.class.getDeclaredField("imports");
                ((Field)object2).setAccessible(true);
                object = (Map)((Field)object2).get(sourceUnit.getAST());
                object.remove(importNode2.getAlias());
            }
            catch (Exception exception) {
                throw UncheckedException.throwAsUncheckedException((Throwable)exception);
            }
        }
        Iterator<Object> iterator = sourceUnit.getAST().getStaticImports().values().iterator();
        while (iterator.hasNext()) {
            importNode2 = (ImportNode)iterator.next();
            if (this.isVisible(sourceUnit, importNode2.getClassName())) continue;
            iterator.remove();
        }
        iterator = sourceUnit.getAST().getStaticStarImports().values().iterator();
        while (iterator.hasNext()) {
            importNode2 = (ImportNode)iterator.next();
            if (this.isVisible(sourceUnit, importNode2.getClassName())) continue;
            iterator.remove();
        }
        importNode2 = this.getScriptClass(sourceUnit);
        object2 = sourceUnit.getAST().getClasses().iterator();
        while (object2.hasNext()) {
            object = (ClassNode)object2.next();
            if (object == importNode2) continue;
            object2.remove();
        }
        if (importNode2 != null) {
            for (MethodNode methodNode : new ArrayList(importNode2.getMethods())) {
                if (methodNode.getName().equals("run")) continue;
                this.removeMethod((ClassNode)importNode2, methodNode);
            }
        }
        sourceUnit.getAST().getMethods().clear();
    }

    private boolean isVisible(SourceUnit sourceUnit, String string) {
        try {
            sourceUnit.getClassLoader().loadClass(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private void filterStatements(SourceUnit sourceUnit, Spec<Statement> spec) {
        Iterator iterator = sourceUnit.getAST().getStatementBlock().getStatements().iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            if (spec.isSatisfiedBy(statement)) continue;
            iterator.remove();
        }
    }

    public Transformer invert() {
        return new AbstractScriptTransformer(){

            protected int getPhase() {
                return 5;
            }

            public String getId() {
                return "no_" + ClasspathScriptTransformer.this.getId();
            }

            public void call(SourceUnit sourceUnit) throws CompilationFailedException {
                NotSpec<Statement> notSpec = Specs.not(ClasspathScriptTransformer.this.isScriptBlock());
                ClasspathScriptTransformer.this.filterStatements(sourceUnit, notSpec);
            }
        };
    }

    public Spec<Statement> isScriptBlock() {
        return new Spec<Statement>(){

            @Override
            public boolean isSatisfiedBy(Statement statement) {
                if (!(statement instanceof ExpressionStatement)) {
                    return false;
                }
                ExpressionStatement expressionStatement = (ExpressionStatement)statement;
                if (!(expressionStatement.getExpression() instanceof MethodCallExpression)) {
                    return false;
                }
                MethodCallExpression methodCallExpression = (MethodCallExpression)expressionStatement.getExpression();
                if (!ClasspathScriptTransformer.this.isMethodOnThis(methodCallExpression, ClasspathScriptTransformer.this.getScriptMethodName())) {
                    return false;
                }
                if (!(methodCallExpression.getArguments() instanceof ArgumentListExpression)) {
                    return false;
                }
                ArgumentListExpression argumentListExpression = (ArgumentListExpression)methodCallExpression.getArguments();
                return argumentListExpression.getExpressions().size() == 1 && argumentListExpression.getExpression(0) instanceof ClosureExpression;
            }
        };
    }
}

