/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.groovy.scripts.Transformer;

public abstract class AbstractScriptTransformer
extends CompilationUnit.SourceUnitOperation
implements Transformer {
    public void register(CompilationUnit compilationUnit) {
        compilationUnit.addPhaseOperation((CompilationUnit.SourceUnitOperation)this, this.getPhase());
    }

    protected abstract int getPhase();

    protected boolean isMethodOnThis(MethodCallExpression methodCallExpression, String string) {
        boolean bl = methodCallExpression.getMethod() instanceof ConstantExpression && methodCallExpression.getMethod().getText().equals(string);
        return bl && this.targetIsThis(methodCallExpression);
    }

    protected boolean targetIsThis(MethodCallExpression methodCallExpression) {
        Expression expression = methodCallExpression.getObjectExpression();
        return expression instanceof VariableExpression && expression.getText().equals("this");
    }

    protected void visitScriptCode(SourceUnit sourceUnit, GroovyCodeVisitor groovyCodeVisitor) {
        sourceUnit.getAST().getStatementBlock().visit(groovyCodeVisitor);
        for (Object e : sourceUnit.getAST().getMethods()) {
            MethodNode methodNode = (MethodNode)e;
            methodNode.getCode().visit(groovyCodeVisitor);
        }
    }

    protected ClassNode getScriptClass(SourceUnit sourceUnit) {
        if (sourceUnit.getAST().getStatementBlock().getStatements().isEmpty() && sourceUnit.getAST().getMethods().isEmpty()) {
            return null;
        }
        return (ClassNode)sourceUnit.getAST().getClasses().get(0);
    }

    protected void removeMethod(ClassNode classNode, MethodNode methodNode) {
        classNode.getMethods().remove(methodNode);
        classNode.getDeclaredMethods(methodNode.getName()).clear();
    }
}

