/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import java.io.File;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.internal.artifacts.CachingDependencyResolveContext;
import org.gradle.api.internal.artifacts.DependencyResolveContext;
import org.gradle.api.internal.artifacts.ProjectDependenciesBuildInstruction;
import org.gradle.api.internal.artifacts.dependencies.AbstractModuleDependency;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectDependency
extends AbstractModuleDependency
implements ProjectDependency {
    private ProjectInternal dependencyProject;
    private final ProjectDependenciesBuildInstruction instruction;
    private final TaskDependencyImpl taskDependency = new TaskDependencyImpl();

    public DefaultProjectDependency(ProjectInternal projectInternal, ProjectDependenciesBuildInstruction projectDependenciesBuildInstruction) {
        this(projectInternal, null, projectDependenciesBuildInstruction);
    }

    public DefaultProjectDependency(ProjectInternal projectInternal, String string, ProjectDependenciesBuildInstruction projectDependenciesBuildInstruction) {
        super(string);
        this.dependencyProject = projectInternal;
        this.instruction = projectDependenciesBuildInstruction;
    }

    @Override
    public Project getDependencyProject() {
        return this.dependencyProject;
    }

    @Override
    public String getGroup() {
        return this.dependencyProject.getGroup().toString();
    }

    @Override
    public String getName() {
        return this.dependencyProject.getName();
    }

    @Override
    public String getVersion() {
        return this.dependencyProject.getVersion().toString();
    }

    @Override
    public Configuration getProjectConfiguration() {
        return this.dependencyProject.getConfigurations().getByName(this.getConfiguration());
    }

    @Override
    public ProjectDependency copy() {
        DefaultProjectDependency defaultProjectDependency = new DefaultProjectDependency(this.dependencyProject, this.getConfiguration(), this.instruction);
        this.copyTo(defaultProjectDependency);
        return defaultProjectDependency;
    }

    @Override
    public Set<File> resolve() {
        return this.resolve(true);
    }

    @Override
    public Set<File> resolve(boolean bl) {
        CachingDependencyResolveContext cachingDependencyResolveContext = new CachingDependencyResolveContext(bl);
        cachingDependencyResolveContext.add(this);
        return cachingDependencyResolveContext.resolve().getFiles();
    }

    @Override
    public void resolve(DependencyResolveContext dependencyResolveContext) {
        boolean bl;
        boolean bl2 = bl = this.isTransitive() && dependencyResolveContext.isTransitive();
        if (bl) {
            for (Dependency dependency : this.getProjectConfiguration().getAllDependencies()) {
                dependencyResolveContext.add(dependency);
            }
        }
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return this.taskDependency;
    }

    @Override
    public boolean contentEquals(Dependency dependency) {
        if (this == dependency) {
            return true;
        }
        if (dependency == null || this.getClass() != dependency.getClass()) {
            return false;
        }
        ProjectDependency projectDependency = (ProjectDependency)dependency;
        if (!this.isCommonContentEquals(projectDependency)) {
            return false;
        }
        return this.dependencyProject.equals(projectDependency.getDependencyProject());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DefaultProjectDependency defaultProjectDependency = (DefaultProjectDependency)object;
        if (!this.getDependencyProject().equals(defaultProjectDependency.getDependencyProject())) {
            return false;
        }
        if (!this.getConfiguration().equals(defaultProjectDependency.getConfiguration())) {
            return false;
        }
        return this.instruction.equals(defaultProjectDependency.instruction);
    }

    @Override
    public int hashCode() {
        return this.getDependencyProject().hashCode() ^ this.getConfiguration().hashCode() ^ this.instruction.hashCode();
    }

    public String toString() {
        return "DefaultProjectDependency{dependencyProject='" + this.dependencyProject + '\'' + ", configuration='" + this.getConfiguration() + '\'' + '}';
    }

    private class TaskDependencyImpl
    extends AbstractTaskDependency {
        private TaskDependencyImpl() {
        }

        public void resolve(TaskDependencyResolveContext taskDependencyResolveContext) {
            if (!DefaultProjectDependency.this.instruction.isRebuild()) {
                return;
            }
            Configuration configuration = DefaultProjectDependency.this.getProjectConfiguration();
            taskDependencyResolveContext.add(configuration);
            taskDependencyResolveContext.add(configuration.getAllArtifacts());
        }
    }
}

