/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.AbstractExternalDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClientModule
extends AbstractExternalDependency
implements ClientModule {
    private String group;
    private String name;
    private String version;
    private boolean force;
    private Set<ModuleDependency> dependencies = new HashSet<ModuleDependency>();

    public DefaultClientModule(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public DefaultClientModule(String string, String string2, String string3, String string4) {
        super(string4);
        if (string2 == null) {
            throw new InvalidUserDataException("Name must not be null!");
        }
        this.group = string;
        this.name = string2;
        this.version = string3;
    }

    private String emptyStringIfNull(String string) {
        return string == null ? "" : string;
    }

    @Override
    public Set<ModuleDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public String getId() {
        return this.emptyStringIfNull(this.group) + ":" + this.emptyStringIfNull(this.name) + ":" + this.emptyStringIfNull(this.version);
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public ClientModule setGroup(String string) {
        this.group = string;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ClientModule setName(String string) {
        this.name = string;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public ClientModule setVersion(String string) {
        this.version = string;
        return this;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public ClientModule setForce(boolean bl) {
        this.force = bl;
        return this;
    }

    @Override
    public void addDependency(ModuleDependency moduleDependency) {
        this.dependencies.add(moduleDependency);
    }

    @Override
    public ClientModule copy() {
        DefaultClientModule defaultClientModule = new DefaultClientModule(this.getGroup(), this.getName(), this.getVersion(), this.getConfiguration());
        this.copyTo(defaultClientModule);
        for (ModuleDependency moduleDependency : this.dependencies) {
            defaultClientModule.addDependency(moduleDependency.copy());
        }
        return defaultClientModule;
    }

    @Override
    public boolean contentEquals(Dependency dependency) {
        if (this == dependency) {
            return true;
        }
        if (dependency == null || this.getClass() != dependency.getClass()) {
            return false;
        }
        ClientModule clientModule = (ClientModule)dependency;
        if (!this.isContentEqualsFor(clientModule)) {
            return false;
        }
        return this.dependencies.equals(clientModule.getDependencies());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClientModule clientModule = (ClientModule)object;
        return this.isContentEqualsFor(clientModule);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

