/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import groovy.lang.Closure;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ExcludeRuleContainer;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.internal.artifacts.DefaultExcludeRuleContainer;
import org.gradle.api.internal.artifacts.dependencies.AbstractDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyArtifact;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModuleDependency
extends AbstractDependency
implements ModuleDependency {
    private ExcludeRuleContainer excludeRuleContainer = new DefaultExcludeRuleContainer();
    private Set<DependencyArtifact> artifacts = new HashSet<DependencyArtifact>();
    private String configuration;
    private boolean transitive = true;

    protected AbstractModuleDependency(String string) {
        this.configuration = GUtil.elvis(string, "default");
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public ModuleDependency setTransitive(boolean bl) {
        this.transitive = bl;
        return this;
    }

    @Override
    public String getConfiguration() {
        return this.configuration;
    }

    @Override
    public ModuleDependency exclude(Map<String, String> map) {
        this.excludeRuleContainer.add(map);
        return this;
    }

    @Override
    public Set<ExcludeRule> getExcludeRules() {
        return this.excludeRuleContainer.getRules();
    }

    private void setExcludeRuleContainer(ExcludeRuleContainer excludeRuleContainer) {
        this.excludeRuleContainer = excludeRuleContainer;
    }

    @Override
    public Set<DependencyArtifact> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(Set<DependencyArtifact> set) {
        this.artifacts = set;
    }

    @Override
    public AbstractModuleDependency addArtifact(DependencyArtifact dependencyArtifact) {
        this.artifacts.add(dependencyArtifact);
        return this;
    }

    @Override
    public DependencyArtifact artifact(Closure closure) {
        DependencyArtifact dependencyArtifact = ConfigureUtil.configure(closure, new DefaultDependencyArtifact());
        this.artifacts.add(dependencyArtifact);
        return dependencyArtifact;
    }

    protected void copyTo(AbstractModuleDependency abstractModuleDependency) {
        super.copyTo(abstractModuleDependency);
        abstractModuleDependency.setArtifacts(new HashSet<DependencyArtifact>(this.getArtifacts()));
        abstractModuleDependency.setExcludeRuleContainer(new DefaultExcludeRuleContainer(this.getExcludeRules()));
        abstractModuleDependency.setTransitive(this.isTransitive());
    }

    protected boolean isKeyEquals(ModuleDependency moduleDependency) {
        if (this.getGroup() != null ? !this.getGroup().equals(moduleDependency.getGroup()) : moduleDependency.getGroup() != null) {
            return false;
        }
        if (!this.getName().equals(moduleDependency.getName())) {
            return false;
        }
        if (!this.getConfiguration().equals(moduleDependency.getConfiguration())) {
            return false;
        }
        return !(this.getVersion() != null ? !this.getVersion().equals(moduleDependency.getVersion()) : moduleDependency.getVersion() != null);
    }

    protected boolean isCommonContentEquals(ModuleDependency moduleDependency) {
        if (!this.isKeyEquals(moduleDependency)) {
            return false;
        }
        if (this.isTransitive() != moduleDependency.isTransitive()) {
            return false;
        }
        if (this.getArtifacts() != null ? !this.getArtifacts().equals(moduleDependency.getArtifacts()) : moduleDependency.getArtifacts() != null) {
            return false;
        }
        return !(this.getExcludeRules() != null ? !this.getExcludeRules().equals(moduleDependency.getExcludeRules()) : moduleDependency.getExcludeRules() != null);
    }
}

