/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations.dynamicversion;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ArtifactIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.artifacts.cache.ArtifactResolutionControl;
import org.gradle.api.artifacts.cache.DependencyResolutionControl;
import org.gradle.api.artifacts.cache.ModuleResolutionControl;
import org.gradle.api.artifacts.cache.ResolutionControl;
import org.gradle.api.artifacts.cache.ResolutionRules;
import org.gradle.api.internal.artifacts.configurations.dynamicversion.CachePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCachePolicy
implements CachePolicy,
ResolutionRules {
    private static final int SECONDS_IN_DAY = 86400;
    private final List<Action<? super DependencyResolutionControl>> dependencyCacheRules = new ArrayList<Action<? super DependencyResolutionControl>>();
    private final List<Action<? super ModuleResolutionControl>> moduleCacheRules = new ArrayList<Action<? super ModuleResolutionControl>>();
    private final List<Action<? super ArtifactResolutionControl>> artifactCacheRules = new ArrayList<Action<? super ArtifactResolutionControl>>();

    public DefaultCachePolicy() {
        this.cacheDynamicVersionsFor(86400, TimeUnit.SECONDS);
        this.cacheChangingModulesFor(86400, TimeUnit.SECONDS);
        this.cacheMissingModulesAndArtifactsFor(86400, TimeUnit.SECONDS);
    }

    @Override
    public void eachDependency(Action<? super DependencyResolutionControl> action) {
        this.dependencyCacheRules.add(0, action);
    }

    @Override
    public void eachModule(Action<? super ModuleResolutionControl> action) {
        this.moduleCacheRules.add(0, action);
    }

    @Override
    public void eachArtifact(Action<? super ArtifactResolutionControl> action) {
        this.artifactCacheRules.add(0, action);
    }

    public void cacheDynamicVersionsFor(final int n, final TimeUnit timeUnit) {
        this.eachDependency((Action<? super DependencyResolutionControl>)new Action<DependencyResolutionControl>(){

            @Override
            public void execute(DependencyResolutionControl dependencyResolutionControl) {
                dependencyResolutionControl.cacheFor(n, timeUnit);
            }
        });
    }

    public void cacheChangingModulesFor(final int n, final TimeUnit timeUnit) {
        this.eachModule((Action<? super ModuleResolutionControl>)new Action<ModuleResolutionControl>(){

            @Override
            public void execute(ModuleResolutionControl moduleResolutionControl) {
                if (moduleResolutionControl.isChanging()) {
                    moduleResolutionControl.cacheFor(n, timeUnit);
                }
            }
        });
    }

    private void cacheMissingModulesAndArtifactsFor(final int n, final TimeUnit timeUnit) {
        this.eachModule((Action<? super ModuleResolutionControl>)new Action<ModuleResolutionControl>(){

            @Override
            public void execute(ModuleResolutionControl moduleResolutionControl) {
                if (moduleResolutionControl.getCachedResult() == null) {
                    moduleResolutionControl.cacheFor(n, timeUnit);
                }
            }
        });
        this.eachArtifact((Action<? super ArtifactResolutionControl>)new Action<ArtifactResolutionControl>(){

            @Override
            public void execute(ArtifactResolutionControl artifactResolutionControl) {
                if (artifactResolutionControl.getCachedResult() == null) {
                    artifactResolutionControl.cacheFor(n, timeUnit);
                }
            }
        });
    }

    @Override
    public boolean mustRefreshDynamicVersion(ModuleVersionSelector moduleVersionSelector, ModuleVersionIdentifier moduleVersionIdentifier, long l) {
        CachedDependencyResolutionControl cachedDependencyResolutionControl = new CachedDependencyResolutionControl(moduleVersionSelector, moduleVersionIdentifier, l);
        for (Action<? super DependencyResolutionControl> action : this.dependencyCacheRules) {
            action.execute(cachedDependencyResolutionControl);
            if (!cachedDependencyResolutionControl.ruleMatch()) continue;
            return cachedDependencyResolutionControl.mustCheck();
        }
        return false;
    }

    @Override
    public boolean mustRefreshModule(ModuleVersionIdentifier moduleVersionIdentifier, ResolvedModuleVersion resolvedModuleVersion, long l) {
        return this.mustRefreshModule(moduleVersionIdentifier, resolvedModuleVersion, l, false);
    }

    @Override
    public boolean mustRefreshChangingModule(ModuleVersionIdentifier moduleVersionIdentifier, ResolvedModuleVersion resolvedModuleVersion, long l) {
        return this.mustRefreshModule(moduleVersionIdentifier, resolvedModuleVersion, l, true);
    }

    private boolean mustRefreshModule(ModuleVersionIdentifier moduleVersionIdentifier, ResolvedModuleVersion resolvedModuleVersion, long l, boolean bl) {
        CachedModuleResolutionControl cachedModuleResolutionControl = new CachedModuleResolutionControl(moduleVersionIdentifier, resolvedModuleVersion, bl, l);
        for (Action<? super ModuleResolutionControl> action : this.moduleCacheRules) {
            action.execute(cachedModuleResolutionControl);
            if (!cachedModuleResolutionControl.ruleMatch()) continue;
            return cachedModuleResolutionControl.mustCheck();
        }
        return false;
    }

    @Override
    public boolean mustRefreshArtifact(ArtifactIdentifier artifactIdentifier, File file, long l) {
        CachedArtifactResolutionControl cachedArtifactResolutionControl = new CachedArtifactResolutionControl(artifactIdentifier, file, l);
        for (Action<? super ArtifactResolutionControl> action : this.artifactCacheRules) {
            action.execute(cachedArtifactResolutionControl);
            if (!cachedArtifactResolutionControl.ruleMatch()) continue;
            return cachedArtifactResolutionControl.mustCheck();
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CachedArtifactResolutionControl
    extends AbstractResolutionControl<ArtifactIdentifier, File>
    implements ArtifactResolutionControl {
        private CachedArtifactResolutionControl(ArtifactIdentifier artifactIdentifier, File file, long l) {
            super(artifactIdentifier, file, l);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CachedModuleResolutionControl
    extends AbstractResolutionControl<ModuleVersionIdentifier, ResolvedModuleVersion>
    implements ModuleResolutionControl {
        private final boolean changing;

        private CachedModuleResolutionControl(ModuleVersionIdentifier moduleVersionIdentifier, ResolvedModuleVersion resolvedModuleVersion, boolean bl, long l) {
            super(moduleVersionIdentifier, resolvedModuleVersion, l);
            this.changing = bl;
        }

        @Override
        public boolean isChanging() {
            return this.changing;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CachedDependencyResolutionControl
    extends AbstractResolutionControl<ModuleVersionSelector, ModuleVersionIdentifier>
    implements DependencyResolutionControl {
        private CachedDependencyResolutionControl(ModuleVersionSelector moduleVersionSelector, ModuleVersionIdentifier moduleVersionIdentifier, long l) {
            super(moduleVersionSelector, moduleVersionIdentifier, l);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractResolutionControl<A, B>
    implements ResolutionControl<A, B> {
        private final A request;
        private final B cachedResult;
        private final long ageMillis;
        private boolean ruleMatch;
        private boolean mustCheck;

        private AbstractResolutionControl(A a, B b, long l) {
            this.request = a;
            this.cachedResult = b;
            this.ageMillis = l;
        }

        @Override
        public A getRequest() {
            return this.request;
        }

        @Override
        public B getCachedResult() {
            return this.cachedResult;
        }

        @Override
        public void cacheFor(int n, TimeUnit timeUnit) {
            long l = TimeUnit.MILLISECONDS.convert(n, timeUnit);
            if (this.ageMillis <= l) {
                this.setMustCheck(false);
            } else {
                this.setMustCheck(true);
            }
        }

        @Override
        public void useCachedResult() {
            this.setMustCheck(false);
        }

        @Override
        public void refresh() {
            this.setMustCheck(true);
        }

        private void setMustCheck(boolean bl) {
            this.ruleMatch = true;
            this.mustCheck = bl;
        }

        public boolean ruleMatch() {
            return this.ruleMatch;
        }

        public boolean mustCheck() {
            return this.mustCheck;
        }
    }
}

