/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Collection;
import java.util.Set;
import org.gradle.api.IllegalDependencyNotation;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.dsl.dependencies.ParsedModuleStringNotation;
import org.gradle.api.internal.notations.NotationParserBuilder;
import org.gradle.api.internal.notations.api.NotationParser;
import org.gradle.api.internal.notations.api.TopLevelNotationParser;
import org.gradle.api.internal.notations.parsers.MapKey;
import org.gradle.api.internal.notations.parsers.MapNotationParser;
import org.gradle.api.internal.notations.parsers.TypedNotationParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForcedModuleNotationParser
implements TopLevelNotationParser,
NotationParser<Set<ModuleVersionSelector>> {
    private NotationParser<Set<ModuleVersionSelector>> delegate = new NotationParserBuilder<ModuleVersionSelector>().resultingType(ModuleVersionSelector.class).parser(new ForcedModuleStringParser()).parser(new ForcedModuleMapParser()).toFlatteningComposite();

    @Override
    public Set<ModuleVersionSelector> parseNotation(Object object) {
        assert (object != null) : "notation cannot be null";
        return this.delegate.parseNotation(object);
    }

    @Override
    public void describe(Collection<String> collection) {
        this.delegate.describe(collection);
    }

    static ModuleVersionSelector selector(String string, String string2, String string3) {
        return new DefaultModuleVersionSelector(string, string2, string3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ForcedModuleStringParser
    extends TypedNotationParser<CharSequence, ModuleVersionSelector> {
        public ForcedModuleStringParser() {
            super(CharSequence.class);
        }

        @Override
        public void describe(Collection<String> collection) {
            collection.add("Strings/CharSequences, e.g. 'org.gradle:gradle-core:1.0'.");
        }

        @Override
        public ModuleVersionSelector parseType(CharSequence charSequence) {
            ParsedModuleStringNotation parsedModuleStringNotation;
            try {
                parsedModuleStringNotation = new ParsedModuleStringNotation(charSequence.toString(), null);
            }
            catch (IllegalDependencyNotation illegalDependencyNotation) {
                throw new InvalidUserDataException("Invalid format: '" + charSequence + "'. The Correct notation is a 3-part group:name:version notation," + "e.g: 'org.gradle:gradle-core:1.0'");
            }
            if (parsedModuleStringNotation.getGroup() == null || parsedModuleStringNotation.getName() == null || parsedModuleStringNotation.getVersion() == null) {
                throw new InvalidUserDataException("Invalid format: '" + charSequence + "'. Group, name and version cannot be empty. Correct example: " + "'org.gradle:gradle-core:1.0'");
            }
            return ForcedModuleNotationParser.selector(parsedModuleStringNotation.getGroup(), parsedModuleStringNotation.getName(), parsedModuleStringNotation.getVersion());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ForcedModuleMapParser
    extends MapNotationParser<ModuleVersionSelector> {
        ForcedModuleMapParser() {
        }

        @Override
        public void describe(Collection<String> collection) {
            collection.add("Maps, e.g. [group: 'org.gradle', name:'gradle-core', version: '1.0'].");
        }

        protected ModuleVersionSelector parseMap(@MapKey(value="group") String string, @MapKey(value="name") String string2, @MapKey(value="version") String string3) {
            return ForcedModuleNotationParser.selector(string, string2, string3);
        }
    }
}

