/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import groovy.lang.Closure;
import java.util.Set;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.gradle.api.internal.AbstractNamedDomainObjectContainer;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.Instantiator;
import org.gradle.api.internal.artifacts.ArtifactDependencyResolver;
import org.gradle.api.internal.artifacts.configurations.ConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DefaultConfiguration;
import org.gradle.api.internal.artifacts.configurations.DefaultResolutionStrategy;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.DetachedConfigurationsProvider;
import org.gradle.listener.ListenerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigurationContainer
extends AbstractNamedDomainObjectContainer<Configuration>
implements ConfigurationContainerInternal,
ConfigurationsProvider {
    public static final String DETACHED_CONFIGURATION_DEFAULT_NAME = "detachedConfiguration";
    private final ArtifactDependencyResolver dependencyResolver;
    private final Instantiator instantiator;
    private final DomainObjectContext context;
    private final ListenerManager listenerManager;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private int detachedConfigurationDefaultNameCounter = 1;

    public DefaultConfigurationContainer(ArtifactDependencyResolver artifactDependencyResolver, Instantiator instantiator, DomainObjectContext domainObjectContext, ListenerManager listenerManager, DependencyMetaDataProvider dependencyMetaDataProvider) {
        super(Configuration.class, instantiator, new Configuration.Namer());
        this.dependencyResolver = artifactDependencyResolver;
        this.instantiator = instantiator;
        this.context = domainObjectContext;
        this.listenerManager = listenerManager;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
    }

    @Override
    protected Configuration doCreate(String string) {
        return this.instantiator.newInstance(DefaultConfiguration.class, this.context.absoluteProjectPath(string), string, this, this.dependencyResolver, this.listenerManager, this.dependencyMetaDataProvider, new DefaultResolutionStrategy());
    }

    @Override
    public Set<Configuration> getAll() {
        return this;
    }

    @Override
    public Configuration add(String string) {
        return (Configuration)this.create(string);
    }

    @Override
    public Configuration add(String string, Closure closure) {
        return (Configuration)this.create(string, closure);
    }

    @Override
    public ConfigurationInternal getByName(String string) {
        return (ConfigurationInternal)super.getByName(string);
    }

    @Override
    public String getTypeDisplayName() {
        return "configuration";
    }

    @Override
    protected UnknownDomainObjectException createNotFoundException(String string) {
        return new UnknownConfigurationException(String.format("Configuration with name '%s' not found.", string));
    }

    @Override
    public Configuration detachedConfiguration(Dependency ... dependencyArray) {
        DetachedConfigurationsProvider detachedConfigurationsProvider = new DetachedConfigurationsProvider();
        String string = DETACHED_CONFIGURATION_DEFAULT_NAME + this.detachedConfigurationDefaultNameCounter++;
        DefaultConfiguration defaultConfiguration = new DefaultConfiguration(string, string, detachedConfigurationsProvider, this.dependencyResolver, this.listenerManager, this.dependencyMetaDataProvider, new DefaultResolutionStrategy());
        DependencySet dependencySet = defaultConfiguration.getDependencies();
        for (Dependency dependency : dependencyArray) {
            dependencySet.add(dependency.copy());
        }
        detachedConfigurationsProvider.setTheOnlyConfiguration(defaultConfiguration);
        return defaultConfiguration;
    }

    public String dump() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Configuration of type: " + this.getTypeDisplayName());
        Set<Configuration> set = this.getAll();
        for (Configuration configuration : set) {
            stringBuilder.append("\n  " + configuration.toString());
        }
        return stringBuilder.toString();
    }
}

