/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.Module;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CompositeDomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.artifacts.ArtifactDependencyResolver;
import org.gradle.api.internal.artifacts.DefaultDependencySet;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.DefaultPublishArtifactSet;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DefaultResolutionStrategy;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.DetachedConfigurationsProvider;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.listener.ListenerBroadcast;
import org.gradle.listener.ListenerManager;
import org.gradle.util.CollectionUtils;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.WrapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfiguration
extends AbstractFileCollection
implements ConfigurationInternal {
    private final String path;
    private final String name;
    private Configuration.Visibility visibility = Configuration.Visibility.PUBLIC;
    private boolean transitive = true;
    private Set<Configuration> extendsFrom = new LinkedHashSet<Configuration>();
    private String description;
    private ConfigurationsProvider configurationsProvider;
    private final ArtifactDependencyResolver dependencyResolver;
    private final ListenerManager listenerManager;
    private final DependencyMetaDataProvider metaDataProvider;
    private final DefaultDependencySet dependencies;
    private final CompositeDomainObjectSet<Dependency> inheritedDependencies;
    private final DefaultDependencySet allDependencies;
    private final DefaultPublishArtifactSet artifacts;
    private final CompositeDomainObjectSet<PublishArtifact> inheritedArtifacts;
    private final DefaultPublishArtifactSet allArtifacts;
    private final ConfigurationResolvableDependencies resolvableDependencies = new ConfigurationResolvableDependencies();
    private final ListenerBroadcast<DependencyResolutionListener> resolutionListenerBroadcast;
    private Set<ExcludeRule> excludeRules = new LinkedHashSet<ExcludeRule>();
    private final Object lock = new Object();
    private Configuration.State state = Configuration.State.UNRESOLVED;
    private ResolvedConfiguration cachedResolvedConfiguration;
    private final DefaultResolutionStrategy resolutionStrategy;

    public DefaultConfiguration(String string, String string2, ConfigurationsProvider configurationsProvider, ArtifactDependencyResolver artifactDependencyResolver, ListenerManager listenerManager, DependencyMetaDataProvider dependencyMetaDataProvider, DefaultResolutionStrategy defaultResolutionStrategy) {
        this.path = string;
        this.name = string2;
        this.configurationsProvider = configurationsProvider;
        this.dependencyResolver = artifactDependencyResolver;
        this.listenerManager = listenerManager;
        this.metaDataProvider = dependencyMetaDataProvider;
        assert (defaultResolutionStrategy != null) : "Cannot create configuration with null resolutionStrategy";
        this.resolutionStrategy = defaultResolutionStrategy;
        this.resolutionListenerBroadcast = listenerManager.createAnonymousBroadcaster(DependencyResolutionListener.class);
        DefaultDomainObjectSet<Dependency> defaultDomainObjectSet = new DefaultDomainObjectSet<Dependency>(Dependency.class);
        defaultDomainObjectSet.beforeChange(new VetoContainerChangeAction());
        this.dependencies = new DefaultDependencySet(String.format("%s dependencies", this.getDisplayName()), defaultDomainObjectSet);
        this.inheritedDependencies = new CompositeDomainObjectSet<Dependency>(Dependency.class, new DomainObjectCollection[]{defaultDomainObjectSet});
        this.allDependencies = new DefaultDependencySet(String.format("%s all dependencies", this.getDisplayName()), this.inheritedDependencies);
        DefaultDomainObjectSet<PublishArtifact> defaultDomainObjectSet2 = new DefaultDomainObjectSet<PublishArtifact>(PublishArtifact.class);
        defaultDomainObjectSet2.beforeChange(new VetoContainerChangeAction());
        this.artifacts = new DefaultPublishArtifactSet(String.format("%s artifacts", this.getDisplayName()), defaultDomainObjectSet2);
        this.inheritedArtifacts = new CompositeDomainObjectSet<PublishArtifact>(PublishArtifact.class, new DomainObjectCollection[]{defaultDomainObjectSet2});
        this.allArtifacts = new DefaultPublishArtifactSet(String.format("%s all artifacts", this.getDisplayName()), this.inheritedArtifacts);
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration.State getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state;
        }
    }

    @Override
    public Module getModule() {
        return this.metaDataProvider.getModule();
    }

    @Override
    public boolean isVisible() {
        return this.visibility == Configuration.Visibility.PUBLIC;
    }

    @Override
    public Configuration setVisible(boolean bl) {
        this.throwExceptionIfNotInUnresolvedState();
        this.visibility = bl ? Configuration.Visibility.PUBLIC : Configuration.Visibility.PRIVATE;
        return this;
    }

    @Override
    public Set<Configuration> getExtendsFrom() {
        return Collections.unmodifiableSet(this.extendsFrom);
    }

    @Override
    public Configuration setExtendsFrom(Set<Configuration> set) {
        this.throwExceptionIfNotInUnresolvedState();
        for (Configuration configuration : this.extendsFrom) {
            this.inheritedArtifacts.removeCollection(configuration.getAllArtifacts());
            this.inheritedDependencies.removeCollection(configuration.getAllDependencies());
        }
        this.extendsFrom = new HashSet<Configuration>();
        for (Configuration configuration : set) {
            this.extendsFrom(configuration);
        }
        return this;
    }

    @Override
    public Configuration extendsFrom(Configuration ... configurationArray) {
        this.throwExceptionIfNotInUnresolvedState();
        for (Configuration configuration : configurationArray) {
            if (configuration.getHierarchy().contains(this)) {
                throw new InvalidUserDataException(String.format("Cyclic extendsFrom from %s and %s is not allowed. See existing hierarchy: %s", this, configuration, configuration.getHierarchy()));
            }
            this.extendsFrom.add(configuration);
            this.inheritedArtifacts.addCollection(configuration.getAllArtifacts());
            this.inheritedDependencies.addCollection(configuration.getAllDependencies());
        }
        return this;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public Configuration setTransitive(boolean bl) {
        this.throwExceptionIfNotInUnresolvedState();
        this.transitive = bl;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Configuration setDescription(String string) {
        this.throwExceptionIfNotInUnresolvedState();
        this.description = string;
        return this;
    }

    @Override
    public Set<Configuration> getHierarchy() {
        Set<Configuration> set = WrapUtil.toLinkedSet(this);
        this.collectSuperConfigs(this, set);
        return set;
    }

    private void collectSuperConfigs(Configuration configuration, Set<Configuration> set) {
        for (Configuration configuration2 : configuration.getExtendsFrom()) {
            if (set.contains(configuration2)) {
                set.remove(configuration2);
            }
            set.add(configuration2);
            this.collectSuperConfigs(configuration2, set);
        }
    }

    @Override
    public Set<Configuration> getAll() {
        return this.configurationsProvider.getAll();
    }

    @Override
    public Set<File> resolve() {
        return this.getFiles();
    }

    @Override
    public Set<File> getFiles() {
        return this.fileCollection(Specs.SATISFIES_ALL).getFiles();
    }

    @Override
    public Set<File> files(Dependency ... dependencyArray) {
        return this.fileCollection(dependencyArray).getFiles();
    }

    @Override
    public Set<File> files(Closure closure) {
        return this.fileCollection(closure).getFiles();
    }

    @Override
    public Set<File> files(Spec<? super Dependency> spec) {
        return this.fileCollection(spec).getFiles();
    }

    @Override
    public FileCollection fileCollection(Spec<? super Dependency> spec) {
        return new ConfigurationFileCollection(spec);
    }

    @Override
    public FileCollection fileCollection(Closure closure) {
        return new ConfigurationFileCollection(closure);
    }

    @Override
    public FileCollection fileCollection(Dependency ... dependencyArray) {
        return new ConfigurationFileCollection(WrapUtil.toLinkedSet(dependencyArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolvedConfiguration getResolvedConfiguration() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == Configuration.State.UNRESOLVED) {
                DependencyResolutionListener dependencyResolutionListener = this.getDependencyResolutionBroadcast();
                ResolvableDependencies resolvableDependencies = this.getIncoming();
                dependencyResolutionListener.beforeResolve(resolvableDependencies);
                this.cachedResolvedConfiguration = this.dependencyResolver.resolve(this);
                this.state = this.cachedResolvedConfiguration.hasError() ? Configuration.State.RESOLVED_WITH_FAILURES : Configuration.State.RESOLVED;
                dependencyResolutionListener.afterResolve(resolvableDependencies);
            }
            return this.cachedResolvedConfiguration;
        }
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return this.allDependencies.getBuildDependencies();
    }

    @Override
    public TaskDependency getTaskDependencyFromProjectDependency(final boolean bl, final String string) {
        return new AbstractTaskDependency(){

            public void resolve(TaskDependencyResolveContext taskDependencyResolveContext) {
                if (bl) {
                    this.addTaskDependenciesFromProjectsIDependOn(string, taskDependencyResolveContext);
                } else {
                    Project project = taskDependencyResolveContext.getTask().getProject();
                    this.addTaskDependenciesFromProjectsDependingOnMe(project, string, taskDependencyResolveContext);
                }
            }

            private void addTaskDependenciesFromProjectsIDependOn(String string2, TaskDependencyResolveContext taskDependencyResolveContext) {
                DomainObjectSet<ProjectDependency> domainObjectSet = DefaultConfiguration.this.getAllDependencies().withType(ProjectDependency.class);
                for (ProjectDependency projectDependency : domainObjectSet) {
                    Task task = (Task)projectDependency.getDependencyProject().getTasks().findByName(string2);
                    if (task == null) continue;
                    taskDependencyResolveContext.add(task);
                }
            }

            private void addTaskDependenciesFromProjectsDependingOnMe(Project project, String string2, TaskDependencyResolveContext taskDependencyResolveContext) {
                Set<Task> set = project.getRootProject().getTasksByName(string2, true);
                for (Task task : set) {
                    Configuration configuration = (Configuration)task.getProject().getConfigurations().findByName(DefaultConfiguration.this.getName());
                    if (configuration == null || !DefaultConfiguration.doesConfigurationDependOnProject(configuration, project)) continue;
                    taskDependencyResolveContext.add(task);
                }
            }
        };
    }

    private static boolean doesConfigurationDependOnProject(Configuration configuration, Project project) {
        DomainObjectSet<ProjectDependency> domainObjectSet = configuration.getAllDependencies().withType(ProjectDependency.class);
        for (ProjectDependency projectDependency : domainObjectSet) {
            if (!projectDependency.getDependencyProject().equals(project)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DependencySet getDependencies() {
        return this.dependencies;
    }

    @Override
    public DependencySet getAllDependencies() {
        return this.allDependencies;
    }

    @Override
    public PublishArtifactSet getArtifacts() {
        return this.artifacts;
    }

    @Override
    public PublishArtifactSet getAllArtifacts() {
        return this.allArtifacts;
    }

    @Override
    public Set<ExcludeRule> getExcludeRules() {
        return Collections.unmodifiableSet(this.excludeRules);
    }

    public void setExcludeRules(Set<ExcludeRule> set) {
        this.throwExceptionIfNotInUnresolvedState();
        this.excludeRules = set;
    }

    @Override
    public DefaultConfiguration exclude(Map<String, String> map) {
        this.throwExceptionIfNotInUnresolvedState();
        this.excludeRules.add(new DefaultExcludeRule(map.get("group"), map.get("module")));
        return this;
    }

    @Override
    public String getUploadTaskName() {
        return Configurations.uploadTaskName(this.getName());
    }

    @Override
    public String getDisplayName() {
        return String.format("configuration '%s'", this.path);
    }

    @Override
    public ResolvableDependencies getIncoming() {
        return this.resolvableDependencies;
    }

    @Override
    public Configuration copy() {
        return this.createCopy(this.getDependencies(), false);
    }

    @Override
    public Configuration copyRecursive() {
        return this.createCopy(this.getAllDependencies(), true);
    }

    @Override
    public Configuration copy(Spec<? super Dependency> spec) {
        return this.createCopy(CollectionUtils.filter(this.getDependencies(), spec), false);
    }

    @Override
    public Configuration copyRecursive(Spec<? super Dependency> spec) {
        return this.createCopy(CollectionUtils.filter(this.getAllDependencies(), spec), true);
    }

    private DefaultConfiguration createCopy(Set<Dependency> set, boolean bl) {
        DetachedConfigurationsProvider detachedConfigurationsProvider = new DetachedConfigurationsProvider();
        DefaultConfiguration defaultConfiguration = new DefaultConfiguration(this.path + "Copy", this.name + "Copy", detachedConfigurationsProvider, this.dependencyResolver, this.listenerManager, this.metaDataProvider, this.resolutionStrategy);
        detachedConfigurationsProvider.setTheOnlyConfiguration(defaultConfiguration);
        defaultConfiguration.visibility = this.visibility;
        defaultConfiguration.transitive = this.transitive;
        defaultConfiguration.description = this.description;
        defaultConfiguration.getArtifacts().addAll(this.getAllArtifacts());
        LinkedHashSet<Configuration> linkedHashSet = new LinkedHashSet<Configuration>();
        linkedHashSet.add(this);
        if (bl) {
            linkedHashSet.addAll(this.getHierarchy());
        }
        for (Configuration object : linkedHashSet) {
            for (ExcludeRule excludeRule : object.getExcludeRules()) {
                defaultConfiguration.excludeRules.add(new DefaultExcludeRule(excludeRule.getGroup(), excludeRule.getModule()));
            }
        }
        DependencySet dependencySet = defaultConfiguration.getDependencies();
        for (Dependency dependency : set) {
            dependencySet.add(dependency.copy());
        }
        return defaultConfiguration;
    }

    @Override
    public Configuration copy(Closure closure) {
        return this.copy(Specs.convertClosureToSpec(closure));
    }

    @Override
    public Configuration copyRecursive(Closure closure) {
        return this.copyRecursive(Specs.convertClosureToSpec(closure));
    }

    @Override
    public DependencyResolutionListener getDependencyResolutionBroadcast() {
        return this.resolutionListenerBroadcast.getSource();
    }

    @Override
    public DefaultResolutionStrategy getResolutionStrategy() {
        return this.resolutionStrategy;
    }

    @Override
    public Configuration resolutionStrategy(Closure closure) {
        ConfigureUtil.configure(closure, this.resolutionStrategy);
        return this;
    }

    private void throwExceptionIfNotInUnresolvedState() {
        if (this.getState() != Configuration.State.UNRESOLVED) {
            throw new InvalidUserDataException("You can't change a configuration which is not in unresolved state!");
        }
    }

    public String dump() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nConfiguration:");
        stringBuilder.append("  class='" + this.getClass() + "'");
        stringBuilder.append("  name='" + this.getName() + "'");
        stringBuilder.append("  hashcode='" + this.hashCode() + "'");
        stringBuilder.append("\nLocal Dependencies:");
        if (this.getDependencies().size() > 0) {
            for (Object object : this.getDependencies()) {
                stringBuilder.append("\n   " + object);
            }
        } else {
            stringBuilder.append("\n   none");
        }
        stringBuilder.append("\nLocal Artifacts:");
        if (this.getArtifacts().size() > 0) {
            for (Object object : this.getArtifacts()) {
                stringBuilder.append("\n   " + object);
            }
        } else {
            stringBuilder.append("\n   none");
        }
        stringBuilder.append("\nAll Dependencies:");
        if (this.getAllDependencies().size() > 0) {
            for (Object object : this.getAllDependencies()) {
                stringBuilder.append("\n   " + object);
            }
        } else {
            stringBuilder.append("\n   none");
        }
        stringBuilder.append("\nAll Artifacts:");
        if (this.getAllArtifacts().size() > 0) {
            for (Object object : this.getAllArtifacts()) {
                stringBuilder.append("\n   " + object);
            }
        } else {
            stringBuilder.append("\n   none");
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigurationResolvableDependencies
    implements ResolvableDependencies {
        private ConfigurationResolvableDependencies() {
        }

        @Override
        public String getName() {
            return DefaultConfiguration.this.name;
        }

        @Override
        public String getPath() {
            return DefaultConfiguration.this.path;
        }

        public String toString() {
            return String.format("dependencies '%s'", DefaultConfiguration.this.path);
        }

        @Override
        public FileCollection getFiles() {
            return DefaultConfiguration.this.fileCollection(Specs.satisfyAll());
        }

        @Override
        public DependencySet getDependencies() {
            return DefaultConfiguration.this.getAllDependencies();
        }

        @Override
        public void beforeResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.resolutionListenerBroadcast.add("beforeResolve", action);
        }

        @Override
        public void beforeResolve(Closure closure) {
            DefaultConfiguration.this.resolutionListenerBroadcast.add("beforeResolve", closure);
        }

        @Override
        public void afterResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.resolutionListenerBroadcast.add("afterResolve", action);
        }

        @Override
        public void afterResolve(Closure closure) {
            DefaultConfiguration.this.resolutionListenerBroadcast.add("afterResolve", closure);
        }
    }

    private class VetoContainerChangeAction
    implements Runnable {
        private VetoContainerChangeAction() {
        }

        public void run() {
            DefaultConfiguration.this.throwExceptionIfNotInUnresolvedState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConfigurationFileCollection
    extends AbstractFileCollection {
        private Spec<? super Dependency> dependencySpec;

        private ConfigurationFileCollection(Spec<? super Dependency> spec) {
            this.dependencySpec = spec;
        }

        public ConfigurationFileCollection(Closure closure) {
            this.dependencySpec = Specs.convertClosureToSpec(closure);
        }

        public ConfigurationFileCollection(final Set<Dependency> set) {
            this.dependencySpec = new Spec<Dependency>(){

                @Override
                public boolean isSatisfiedBy(Dependency dependency) {
                    return set.contains(dependency);
                }
            };
        }

        @Override
        public TaskDependency getBuildDependencies() {
            return DefaultConfiguration.this.getBuildDependencies();
        }

        public Spec<? super Dependency> getDependencySpec() {
            return this.dependencySpec;
        }

        @Override
        public String getDisplayName() {
            return String.format("%s dependencies", DefaultConfiguration.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<File> getFiles() {
            Object object = DefaultConfiguration.this.lock;
            synchronized (object) {
                ResolvedConfiguration resolvedConfiguration = DefaultConfiguration.this.getResolvedConfiguration();
                if (DefaultConfiguration.this.getState() == Configuration.State.RESOLVED_WITH_FAILURES) {
                    resolvedConfiguration.rethrowFailure();
                }
                return resolvedConfiguration.getFiles(this.dependencySpec);
            }
        }
    }
}

