/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configurations {
    public static Set<String> getNames(Collection<Configuration> collection, boolean bl) {
        Set<Configuration> set = new HashSet<Configuration>(collection);
        if (bl) {
            set = Configurations.createAllConfigurations(collection);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Configuration configuration : set) {
            hashSet.add(configuration.getName());
        }
        return hashSet;
    }

    public static Set<String> getNames(Collection<Configuration> collection) {
        return Configurations.getNames(collection, false);
    }

    private static Set<Configuration> createAllConfigurations(Collection<Configuration> collection) {
        HashSet<Configuration> hashSet = new HashSet<Configuration>();
        for (Configuration configuration : collection) {
            hashSet.addAll(configuration.getHierarchy());
        }
        return hashSet;
    }

    public static String uploadInternalTaskName(String string) {
        return String.format("upload%sInternal", Configurations.getCapitalName(string));
    }

    public static String uploadTaskName(String string) {
        return String.format("upload%s", Configurations.getCapitalName(string));
    }

    private static String getCapitalName(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }
}

