/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Namer;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.ArtifactRepositoryContainer;
import org.gradle.api.artifacts.UnknownRepositoryException;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.internal.DefaultNamedDomainObjectList;
import org.gradle.api.internal.Instantiator;
import org.gradle.api.internal.artifacts.ResolverFactory;
import org.gradle.api.internal.artifacts.repositories.ArtifactRepositoryInternal;
import org.gradle.api.internal.artifacts.repositories.FixedResolverArtifactRepository;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArtifactRepositoryContainer
extends DefaultNamedDomainObjectList<ArtifactRepository>
implements ArtifactRepositoryContainer {
    private final ResolverFactory resolverFactory;
    private final Action<ArtifactRepository> addLastAction = new Action<ArtifactRepository>(){

        @Override
        public void execute(ArtifactRepository artifactRepository) {
            DefaultArtifactRepositoryContainer.super.add(artifactRepository);
        }
    };
    private final Action<ArtifactRepository> addFirstAction = new Action<ArtifactRepository>(){

        @Override
        public void execute(ArtifactRepository artifactRepository) {
            DefaultArtifactRepositoryContainer.super.add(0, artifactRepository);
        }
    };

    public DefaultArtifactRepositoryContainer(ResolverFactory resolverFactory, Instantiator instantiator) {
        super(ArtifactRepository.class, instantiator, new RepositoryNamer());
        this.resolverFactory = resolverFactory;
    }

    @Override
    public String getTypeDisplayName() {
        return "repository";
    }

    @Override
    public DefaultArtifactRepositoryContainer configure(Closure closure) {
        return ConfigureUtil.configure(closure, this, false);
    }

    @Override
    public void addFirst(ArtifactRepository artifactRepository) {
        this.add(0, artifactRepository);
    }

    @Override
    public void addLast(ArtifactRepository artifactRepository) {
        this.add(artifactRepository);
    }

    @Override
    public boolean add(DependencyResolver dependencyResolver, Closure closure) {
        this.addCustomDependencyResolver(dependencyResolver, closure, this.addLastAction);
        return true;
    }

    @Override
    public boolean add(DependencyResolver dependencyResolver) {
        this.addCustomDependencyResolver(dependencyResolver, null, this.addLastAction);
        return true;
    }

    @Override
    public DependencyResolver addFirst(Object object) {
        return this.addFirst(object, null);
    }

    @Override
    public DependencyResolver addFirst(Object object, Closure closure) {
        return this.addCustomDependencyResolver(object, closure, this.addFirstAction);
    }

    @Override
    @Deprecated
    public DependencyResolver addLast(Object object) {
        DeprecationLogger.nagUserOfReplacedMethod("ArtifactRepositoryContainer.addLast()", "maven() or add()");
        return this.addCustomDependencyResolver(object, null, this.addLastAction);
    }

    @Override
    @Deprecated
    public DependencyResolver addLast(Object object, Closure closure) {
        DeprecationLogger.nagUserOfReplacedMethod("ArtifactRepositoryContainer.addLast()", "maven() or add()");
        return this.addCustomDependencyResolver(object, closure, this.addLastAction);
    }

    @Override
    public DependencyResolver addBefore(Object object, String string) {
        return this.addBefore(object, string, null);
    }

    @Override
    public DependencyResolver addBefore(Object object, String string, Closure closure) {
        if (!GUtil.isTrue(string)) {
            throw new InvalidUserDataException("You must specify afterResolverName");
        }
        final ArtifactRepository artifactRepository = (ArtifactRepository)this.getByName(string);
        return this.addCustomDependencyResolver(object, closure, new Action<ArtifactRepository>(){

            @Override
            public void execute(ArtifactRepository artifactRepository2) {
                DefaultArtifactRepositoryContainer.super.add(DefaultArtifactRepositoryContainer.this.indexOf(artifactRepository), artifactRepository2);
            }
        });
    }

    @Override
    public DependencyResolver addAfter(Object object, String string) {
        return this.addAfter(object, string, null);
    }

    @Override
    public DependencyResolver addAfter(Object object, String string, Closure closure) {
        if (!GUtil.isTrue(string)) {
            throw new InvalidUserDataException("You must specify beforeResolverName");
        }
        final ArtifactRepository artifactRepository = (ArtifactRepository)this.getByName(string);
        return this.addCustomDependencyResolver(object, closure, new Action<ArtifactRepository>(){

            @Override
            public void execute(ArtifactRepository artifactRepository2) {
                int n = DefaultArtifactRepositoryContainer.this.indexOf(artifactRepository) + 1;
                if (n == DefaultArtifactRepositoryContainer.this.size()) {
                    DefaultArtifactRepositoryContainer.super.add(artifactRepository2);
                } else {
                    DefaultArtifactRepositoryContainer.this.add(n, artifactRepository2);
                }
            }
        });
    }

    private DependencyResolver addCustomDependencyResolver(Object object, Closure closure, Action<ArtifactRepository> action) {
        ArtifactRepository artifactRepository = this.resolverFactory.createRepository(object);
        DependencyResolver dependencyResolver = this.toResolver(DependencyResolver.class, artifactRepository);
        ConfigureUtil.configure(closure, dependencyResolver);
        this.addRepository(new FixedResolverArtifactRepository(dependencyResolver), "repository", action);
        return dependencyResolver;
    }

    @Override
    protected UnknownDomainObjectException createNotFoundException(String string) {
        return new UnknownRepositoryException(String.format("Repository with name '%s' not found.", string));
    }

    @Override
    public List<DependencyResolver> getResolvers() {
        ArrayList<DependencyResolver> arrayList = new ArrayList<DependencyResolver>();
        for (ArtifactRepository artifactRepository : this) {
            arrayList.add(((ArtifactRepositoryInternal)artifactRepository).createResolver());
        }
        return arrayList;
    }

    public ResolverFactory getResolverFactory() {
        return this.resolverFactory;
    }

    protected <T extends ArtifactRepository> T addRepository(T t, Action<? super T> action, String string) {
        action.execute(t);
        return this.addRepository(t, string);
    }

    public <T extends ArtifactRepository> T addRepository(T t, Closure closure, String string) {
        return this.addRepository(t, closure, string, this.addLastAction);
    }

    public <T extends ArtifactRepository> T addRepository(T t, Map<String, ?> map, Closure closure, String string) {
        ConfigureUtil.configureByMap(map, t);
        return this.addRepository(t, closure, string);
    }

    protected <T extends ArtifactRepository> T addRepository(T t, Closure closure, String string, Action<ArtifactRepository> action) {
        ConfigureUtil.configure(closure, t);
        return this.addRepository(t, string, action);
    }

    public <T extends ArtifactRepository> T addRepository(T t, Map<String, ?> map, String string) {
        ConfigureUtil.configureByMap(map, t);
        this.addRepository(t, string);
        return t;
    }

    public <T extends ArtifactRepository> T addRepository(T t, String string) {
        return this.addRepository(t, string, this.addLastAction);
    }

    protected <T extends ArtifactRepository> T addRepository(T t, String string, Action<ArtifactRepository> action) {
        String string2 = t.getName();
        if (!GUtil.isTrue(string2)) {
            string2 = this.findName(string);
            t.setName(string2);
        }
        this.assertCanAdd(string2);
        action.execute(t);
        return t;
    }

    protected String findName(String string) {
        if (this.findByName(string) == null) {
            return string;
        }
        int n = 2;
        String string2;
        while (this.findByName(string2 = String.format("%s%d", string, n)) != null) {
            ++n;
        }
        return string2;
    }

    protected <T extends DependencyResolver> T toResolver(Class<T> clazz, ArtifactRepository artifactRepository) {
        DependencyResolver dependencyResolver = ((ArtifactRepositoryInternal)artifactRepository).createResolver();
        return (T)((DependencyResolver)clazz.cast(dependencyResolver));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RepositoryNamer
    implements Namer<ArtifactRepository> {
        private RepositoryNamer() {
        }

        @Override
        public String determineName(ArtifactRepository artifactRepository) {
            return artifactRepository.getName();
        }
    }
}

