/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.util.IndentPrinter;
import groovy.util.Node;
import groovy.util.XmlNodePrinter;
import groovy.util.XmlParser;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.XmlProvider;
import org.gradle.api.internal.DomNode;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.UncheckedException;
import org.gradle.util.GUtil;
import org.gradle.util.TextUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlTransformer
implements Transformer<String, String> {
    private final List<Action<? super XmlProvider>> actions = new ArrayList<Action<? super XmlProvider>>();
    private String indentation = "  ";

    public void addAction(Action<? super XmlProvider> action) {
        this.actions.add(action);
    }

    public void setIndentation(String string) {
        this.indentation = string;
    }

    public void addAction(Closure closure) {
        this.actions.add((Action)DefaultGroovyMethods.asType((Closure)closure, Action.class));
    }

    @Override
    public String transform(String string) {
        return this.doTransform(string).toString();
    }

    public void transform(String string, Writer writer) {
        this.doTransform(string).writeTo(writer);
    }

    public void transform(String string, OutputStream outputStream) {
        this.doTransform(string).writeTo(outputStream);
    }

    public void transform(Node node, Writer writer) {
        this.doTransform(node).writeTo(writer);
    }

    public void transform(Node node, OutputStream outputStream) {
        this.doTransform(node).writeTo(outputStream);
    }

    public void transform(DomNode domNode, Writer writer) {
        this.doTransform(domNode).writeTo(writer);
    }

    public void transform(DomNode domNode, OutputStream outputStream) {
        this.doTransform(domNode).writeTo(outputStream);
    }

    private XmlProviderImpl doTransform(String string) {
        return this.doTransform(new XmlProviderImpl(string));
    }

    private XmlProviderImpl doTransform(Node node) {
        return this.doTransform(new XmlProviderImpl(node));
    }

    private XmlProviderImpl doTransform(DomNode domNode) {
        return this.doTransform(new XmlProviderImpl(domNode));
    }

    private XmlProviderImpl doTransform(XmlProviderImpl xmlProviderImpl) {
        xmlProviderImpl.apply(this.actions);
        return xmlProviderImpl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class XmlProviderImpl
    implements XmlProvider {
        private StringBuilder builder;
        private Node node;
        private String stringValue;
        private Element element;
        private String publicId;
        private String systemId;

        public XmlProviderImpl(String string) {
            this.stringValue = string;
        }

        public XmlProviderImpl(Node node) {
            this.node = node;
        }

        public XmlProviderImpl(DomNode domNode) {
            this.node = domNode;
            this.publicId = domNode.getPublicId();
            this.systemId = domNode.getSystemId();
        }

        public void apply(Iterable<Action<? super XmlProvider>> iterable) {
            for (Action<? super XmlProvider> action : iterable) {
                action.execute(this);
            }
        }

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            this.writeTo(stringWriter);
            return stringWriter.toString();
        }

        public void writeTo(Writer writer) {
            this.doWriteTo(writer, null);
        }

        public void writeTo(OutputStream outputStream) {
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                this.doWriteTo(outputStreamWriter, "UTF-8");
                ((Writer)outputStreamWriter).flush();
            }
            catch (IOException iOException) {
                throw UncheckedException.throwAsUncheckedException((Throwable)iOException);
            }
        }

        @Override
        public StringBuilder asString() {
            if (this.builder == null) {
                this.builder = new StringBuilder(this.toString());
                this.node = null;
                this.element = null;
            }
            return this.builder;
        }

        @Override
        public Node asNode() {
            if (this.node == null) {
                try {
                    this.node = new XmlParser().parseText(this.toString());
                }
                catch (Exception exception) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)exception);
                }
                this.builder = null;
                this.element = null;
            }
            return this.node;
        }

        @Override
        public Element asElement() {
            if (this.element == null) {
                Document document;
                try {
                    document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(this.toString())));
                }
                catch (Exception exception) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)exception);
                }
                this.element = document.getDocumentElement();
                this.builder = null;
                this.node = null;
            }
            return this.element;
        }

        private void doWriteTo(Writer writer, String string) {
            this.writeXmlDeclaration(writer, string);
            try {
                if (this.node != null) {
                    this.printNode(this.node, writer);
                } else if (this.element != null) {
                    this.printDomNode(this.element, writer);
                } else if (this.builder != null) {
                    writer.append(TextUtil.toPlatformLineSeparators(this.stripXmlDeclaration(this.builder)));
                } else {
                    writer.append(TextUtil.toPlatformLineSeparators(this.stripXmlDeclaration(this.stringValue)));
                }
            }
            catch (IOException iOException) {
                throw UncheckedException.throwAsUncheckedException((Throwable)iOException);
            }
        }

        private void printNode(Node node, Writer writer) {
            final PrintWriter printWriter = new PrintWriter(writer);
            if (GUtil.isTrue(this.publicId)) {
                printWriter.format("<!DOCTYPE %s PUBLIC \"%s\" \"%s\">%n", node.name(), this.publicId, this.systemId);
            }
            IndentPrinter indentPrinter = new IndentPrinter(printWriter, XmlTransformer.this.indentation){

                public void println() {
                    printWriter.println();
                }
            };
            XmlNodePrinter xmlNodePrinter = new XmlNodePrinter(indentPrinter);
            xmlNodePrinter.setPreserveWhitespace(true);
            xmlNodePrinter.print(node);
            printWriter.flush();
        }

        private void printDomNode(org.w3c.dom.Node node, Writer writer) {
            this.removeEmptyTextNodes(node);
            int n = this.determineIndentAmount();
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                try {
                    transformerFactory.setAttribute("indent-number", n);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                javax.xml.transform.Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                if (GUtil.isTrue(this.publicId)) {
                    transformer.setOutputProperty("doctype-public", this.publicId);
                    transformer.setOutputProperty("doctype-system", this.systemId);
                }
                try {
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(n));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                transformer.transform(new DOMSource(node), new StreamResult(writer));
            }
            catch (TransformerException transformerException) {
                throw UncheckedException.throwAsUncheckedException((Throwable)transformerException);
            }
        }

        private int determineIndentAmount() {
            if (XmlTransformer.this.indentation.equals("\t")) {
                return 2;
            }
            return XmlTransformer.this.indentation.length();
        }

        private void removeEmptyTextNodes(org.w3c.dom.Node node) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                org.w3c.dom.Node node2 = nodeList.item(i);
                if (node2.getNodeType() == 3 && node2.getNodeValue().trim().length() == 0) {
                    node.removeChild(node2);
                    continue;
                }
                this.removeEmptyTextNodes(node2);
            }
        }

        private void writeXmlDeclaration(Writer writer, String string) {
            try {
                writer.write("<?xml version=\"1.0\"");
                if (string != null) {
                    writer.write(" encoding=\"");
                    writer.write(string);
                    writer.write("\"");
                }
                writer.write("?>");
                writer.write(SystemProperties.getLineSeparator());
            }
            catch (IOException iOException) {
                throw UncheckedException.throwAsUncheckedException((Throwable)iOException);
            }
        }

        private boolean hasXmlDeclaration(String string) {
            return string.startsWith("<?xml");
        }

        private String stripXmlDeclaration(CharSequence charSequence) {
            String string = charSequence.toString();
            if (this.hasXmlDeclaration(string)) {
                string = string.substring(string.indexOf("?>") + 2);
                string = StringUtils.stripStart((String)string, null);
            }
            return string;
        }
    }
}

