/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.Stack;
import org.gradle.api.internal.AsmBackedClassGenerator;
import org.gradle.api.internal.ClassGeneratorBackedInstantiator;
import org.gradle.api.internal.DirectInstantiator;
import org.gradle.api.internal.Instantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ThreadGlobalInstantiator {
    private static final ThreadLocal<Stack<Instantiator>> STORAGE = new ThreadLocal<Stack<Instantiator>>(){

        @Override
        protected Stack<Instantiator> initialValue() {
            return new Stack<Instantiator>();
        }
    };

    private static Stack<Instantiator> getStack() {
        return STORAGE.get();
    }

    public static Instantiator get() {
        Stack<Instantiator> stack = ThreadGlobalInstantiator.getStack();
        return stack.empty() ? null : stack.peek();
    }

    public static void set(Instantiator instantiator) {
        Stack<Instantiator> stack = ThreadGlobalInstantiator.getStack();
        if (instantiator != null) {
            stack.push(instantiator);
        } else if (!stack.empty()) {
            stack.pop();
        }
    }

    public static Instantiator getOrCreate() {
        Instantiator instantiator = ThreadGlobalInstantiator.get();
        if (instantiator != null) {
            return instantiator;
        }
        return new ClassGeneratorBackedInstantiator(new AsmBackedClassGenerator(), new DirectInstantiator());
    }
}

