/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.api.internal.Contextual;
import org.gradle.api.internal.MultiCauseException;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationAwareException
extends GradleException {
    private final Throwable target;
    private final ScriptSource source;
    private final Integer lineNumber;

    public LocationAwareException(Throwable throwable, Throwable throwable2, ScriptSource scriptSource, Integer n) {
        this.source = scriptSource;
        this.lineNumber = n;
        this.target = throwable2;
        this.initCause(throwable);
    }

    public Throwable getTarget() {
        return this.target;
    }

    public String getOriginalMessage() {
        return this.target.getMessage();
    }

    public ScriptSource getScriptSource() {
        return this.source;
    }

    public String getLocation() {
        if (this.source == null) {
            return null;
        }
        String string = StringUtils.capitalize((String)this.source.getDisplayName());
        if (this.lineNumber == null) {
            return string;
        }
        return String.format("%s line: %d", string, this.lineNumber);
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getMessage() {
        String string = this.getLocation();
        String string2 = this.target.getMessage();
        if (string == null && string2 == null) {
            return null;
        }
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        return String.format("%s%n%s", string, string2);
    }

    public List<Throwable> getReportableCauses() {
        final ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        this.visitCauses(this.target, (TreeVisitor<? super Throwable>)new TreeVisitor<Throwable>(){

            @Override
            public void node(Throwable throwable) {
                arrayList.add(throwable);
            }
        });
        return arrayList;
    }

    public void visitReportableCauses(TreeVisitor<? super Throwable> treeVisitor) {
        treeVisitor.node(this);
        this.visitCauses(this.target, treeVisitor);
    }

    private void visitCauses(Throwable throwable, TreeVisitor<? super Throwable> treeVisitor) {
        if (throwable instanceof MultiCauseException) {
            MultiCauseException multiCauseException = (MultiCauseException)((Object)throwable);
            List<? extends Throwable> list = multiCauseException.getCauses();
            if (!list.isEmpty()) {
                treeVisitor.startChildren();
                for (Throwable throwable2 : list) {
                    treeVisitor.node(throwable2);
                    if (throwable2.getClass().getAnnotation(Contextual.class) == null) continue;
                    this.visitCauses(throwable2, treeVisitor);
                }
                treeVisitor.endChildren();
            }
        } else if (throwable.getCause() != null) {
            treeVisitor.startChildren();
            Throwable throwable3 = throwable.getCause();
            treeVisitor.node(throwable3);
            if (throwable3.getClass().getAnnotation(Contextual.class) != null) {
                this.visitCauses(throwable3, treeVisitor);
            }
            treeVisitor.endChildren();
        }
    }
}

