/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.CachingDirectedGraphWalker;
import org.gradle.api.internal.DirectedGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphAggregator<N> {
    private final CachingDirectedGraphWalker<N, N> graphWalker;

    public GraphAggregator(DirectedGraph<N, ?> directedGraph) {
        this.graphWalker = new CachingDirectedGraphWalker(new ConnectedNodesAsValuesDirectedGraph(directedGraph));
    }

    public Result<N> group(Collection<? extends N> collection, Collection<? extends N> collection2) {
        HashMap<Object, Set<N>> hashMap = new HashMap<Object, Set<N>>();
        LinkedHashSet<N> linkedHashSet = new LinkedHashSet<N>(collection2);
        for (Object object : collection2) {
            Set<Object> set = this.graphWalker.add(object).findValues();
            hashMap.put(object, set);
            linkedHashSet.removeAll(set);
        }
        linkedHashSet.addAll(collection);
        HashMap hashMap2 = new HashMap();
        for (Set<Object> set : linkedHashSet) {
            hashMap2.put(set, this.calculateReachableNodes(hashMap, set, linkedHashSet));
        }
        return new Result<N>(hashMap2, linkedHashSet);
    }

    private Set<N> calculateReachableNodes(Map<N, Set<N>> map, N n, Set<N> set) {
        Set<N> set2 = map.get(n);
        set2.add(n);
        LinkedHashSet<N> linkedHashSet = new LinkedHashSet<N>(set);
        linkedHashSet.retainAll(set2);
        linkedHashSet.remove(n);
        for (Object e : linkedHashSet) {
            set2.removeAll(this.calculateReachableNodes(map, e, set));
        }
        return set2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectedNodesAsValuesDirectedGraph<N>
    implements DirectedGraph<N, N> {
        private final DirectedGraph<N, ?> graph;

        private ConnectedNodesAsValuesDirectedGraph(DirectedGraph<N, ?> directedGraph) {
            this.graph = directedGraph;
        }

        @Override
        public void getNodeValues(N n, Collection<N> collection, Collection<N> collection2) {
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            this.graph.getNodeValues(n, new ArrayList(), linkedHashSet);
            collection.addAll(linkedHashSet);
            collection2.addAll(linkedHashSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Result<N> {
        private final Map<N, Set<N>> nodes;
        private final Set<N> topLevelNodes;

        public Result(Map<N, Set<N>> map, Set<N> set) {
            this.nodes = map;
            this.topLevelNodes = set;
        }

        public Set<N> getNodes(N n) {
            return this.nodes.get(n);
        }

        public Set<N> getTopLevelNodes() {
            return this.topLevelNodes;
        }
    }
}

