/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.MissingPropertyException;
import java.util.ArrayList;
import java.util.Map;
import org.gradle.api.internal.AbstractDynamicObject;
import org.gradle.api.internal.BeanDynamicObject;
import org.gradle.api.internal.CompositeDynamicObject;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.internal.Instantiator;
import org.gradle.api.internal.plugins.DefaultConvention;
import org.gradle.api.internal.plugins.ExtraPropertiesDynamicObjectAdapter;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtraPropertiesExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibleDynamicObject
extends CompositeDynamicObject
implements HasConvention {
    private final Object delegate;
    private final AbstractDynamicObject dynamicDelegate;
    private DynamicObject parent;
    private Convention convention;
    private DynamicObject beforeConvention;
    private DynamicObject afterConvention;
    private DynamicObject extraPropertiesDynamicObject;

    public ExtensibleDynamicObject(Object object) {
        this(object, (AbstractDynamicObject)new BeanDynamicObject(object), new DefaultConvention());
    }

    public ExtensibleDynamicObject(Object object, Instantiator instantiator) {
        this(object, (AbstractDynamicObject)new BeanDynamicObject(object), new DefaultConvention(instantiator));
    }

    public ExtensibleDynamicObject(Object object, AbstractDynamicObject abstractDynamicObject, Instantiator instantiator) {
        this(object, abstractDynamicObject, new DefaultConvention(instantiator));
    }

    public ExtensibleDynamicObject(Object object, AbstractDynamicObject abstractDynamicObject, Convention convention) {
        this.delegate = object;
        this.dynamicDelegate = abstractDynamicObject;
        this.convention = convention;
        this.extraPropertiesDynamicObject = new ExtraPropertiesDynamicObjectAdapter(object, this, convention.getExtraProperties());
        this.updateDelegates();
    }

    private void updateDelegates() {
        ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>();
        arrayList.add(this.dynamicDelegate);
        arrayList.add(this.extraPropertiesDynamicObject);
        if (this.beforeConvention != null) {
            arrayList.add(this.beforeConvention);
        }
        if (this.convention != null) {
            arrayList.add(this.convention.getExtensionsAsDynamicObject());
        }
        if (this.afterConvention != null) {
            arrayList.add(this.afterConvention);
        }
        if (this.parent != null) {
            arrayList.add(this.parent);
        }
        this.setObjects(arrayList.toArray(new DynamicObject[arrayList.size()]));
        arrayList.remove(this.parent);
        arrayList.add(this.extraPropertiesDynamicObject);
        this.setObjectsForUpdate(arrayList.toArray(new DynamicObject[arrayList.size()]));
    }

    @Override
    protected String getDisplayName() {
        return this.dynamicDelegate.getDisplayName();
    }

    public ExtraPropertiesExtension getDynamicProperties() {
        return this.convention.getExtraProperties();
    }

    public void addProperties(Map<String, ?> map) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            this.getDynamicProperties().set(entry.getKey(), entry.getValue());
        }
    }

    public DynamicObject getParent() {
        return this.parent;
    }

    public void setParent(DynamicObject dynamicObject) {
        this.parent = dynamicObject;
        this.updateDelegates();
    }

    @Override
    public Convention getConvention() {
        return this.convention;
    }

    public void addObject(DynamicObject dynamicObject, Location location) {
        switch (location) {
            case BeforeConvention: {
                this.beforeConvention = dynamicObject;
                break;
            }
            case AfterConvention: {
                this.afterConvention = dynamicObject;
            }
        }
        this.updateDelegates();
    }

    public DynamicObject getInheritable() {
        return new InheritedDynamicObject();
    }

    private ExtensibleDynamicObject snapshotInheritable() {
        AbstractDynamicObject abstractDynamicObject = new AbstractDynamicObject(){

            protected String getDisplayName() {
                return ExtensibleDynamicObject.this.dynamicDelegate.getDisplayName();
            }
        };
        ExtensibleDynamicObject extensibleDynamicObject = new ExtensibleDynamicObject(abstractDynamicObject);
        extensibleDynamicObject.parent = this.parent;
        extensibleDynamicObject.convention = this.convention;
        extensibleDynamicObject.extraPropertiesDynamicObject = this.extraPropertiesDynamicObject;
        if (this.beforeConvention != null) {
            extensibleDynamicObject.beforeConvention = this.beforeConvention;
        }
        extensibleDynamicObject.updateDelegates();
        return extensibleDynamicObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InheritedDynamicObject
    implements DynamicObject {
        private InheritedDynamicObject() {
        }

        @Override
        public void setProperty(String string, Object object) {
            throw new MissingPropertyException(String.format("Could not find property '%s' inherited from %s.", string, ExtensibleDynamicObject.this.dynamicDelegate.getDisplayName()));
        }

        @Override
        public boolean hasProperty(String string) {
            return ExtensibleDynamicObject.this.snapshotInheritable().hasProperty(string);
        }

        @Override
        public Object getProperty(String string) {
            return ExtensibleDynamicObject.this.snapshotInheritable().getProperty(string);
        }

        public Map<String, Object> getProperties() {
            return ExtensibleDynamicObject.this.snapshotInheritable().getProperties();
        }

        @Override
        public boolean hasMethod(String string, Object ... objectArray) {
            return ExtensibleDynamicObject.this.snapshotInheritable().hasMethod(string, objectArray);
        }

        @Override
        public Object invokeMethod(String string, Object ... objectArray) {
            return ExtensibleDynamicObject.this.snapshotInheritable().invokeMethod(string, objectArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Location {
        BeforeConvention,
        AfterConvention;

    }
}

