/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.File;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.PluginModuleRegistry;
import org.gradle.util.ClassPath;
import org.gradle.util.DefaultClassPath;

public class DynamicModulesClassPathProvider
implements ClassPathProvider {
    private final ModuleRegistry moduleRegistry;
    private final PluginModuleRegistry pluginModuleRegistry;

    public DynamicModulesClassPathProvider(ModuleRegistry moduleRegistry, PluginModuleRegistry pluginModuleRegistry) {
        this.moduleRegistry = moduleRegistry;
        this.pluginModuleRegistry = pluginModuleRegistry;
    }

    public ClassPath findClassPath(String string) {
        if (string.equals("GRADLE_PLUGINS")) {
            ClassPath classPath = new DefaultClassPath(new File[0]);
            for (Module module : this.pluginModuleRegistry.getPluginModules()) {
                classPath = classPath.plus(module.getClasspath());
            }
            return classPath;
        }
        if (string.equals("GRADLE_CORE_IMPL")) {
            return this.moduleRegistry.getModule("gradle-core-impl").getClasspath();
        }
        return null;
    }
}

