/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.File;
import org.gradle.api.internal.GradleDistributionLocator;

public class DocumentationRegistry {
    private final GradleDistributionLocator locator;

    public DocumentationRegistry(GradleDistributionLocator gradleDistributionLocator) {
        this.locator = gradleDistributionLocator;
    }

    public String getDocumentationFor(String string) {
        if (this.locator.getGradleHome() != null) {
            File file = new File(this.locator.getGradleHome(), String.format("docs/userguide/%s.html", string));
            File file2 = new File(this.locator.getGradleHome(), "docs/userguide/userguide.html");
            if (file.isFile() && file2.isFile()) {
                return file.getAbsolutePath();
            }
            if (!file.isFile() && file2.isFile()) {
                throw new IllegalArgumentException(String.format("User guide page '%s' not found.", file));
            }
            if (file.isFile() && !file2.isFile()) {
                throw new IllegalArgumentException(String.format("User guide page '%s' not found.", file2));
            }
        }
        return String.format("http://gradle.org/docs/current/userguide/%s.html", string);
    }
}

