/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.gradle.api.internal.Instantiator;
import org.gradle.internal.UncheckedException;
import org.gradle.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectInstantiator
implements Instantiator {
    @Override
    public <T> T newInstance(Class<T> clazz, Object ... objectArray) {
        try {
            ArrayList arrayList = new ArrayList();
            for (Constructor<?> constructor : clazz.getConstructors()) {
                if (!this.isMatch(constructor, objectArray)) continue;
                arrayList.add(constructor);
            }
            if (arrayList.isEmpty()) {
                throw new IllegalArgumentException(String.format("Could not find any public constructor for %s which accepts parameters %s.", clazz, Arrays.toString(objectArray)));
            }
            if (arrayList.size() > 1) {
                throw new IllegalArgumentException(String.format("Found multiple public constructors for %s which accept parameters %s.", clazz, Arrays.toString(objectArray)));
            }
            return clazz.cast(((Constructor)arrayList.get(0)).newInstance(objectArray));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw UncheckedException.throwAsUncheckedException((Throwable)invocationTargetException.getCause());
        }
        catch (Exception exception) {
            throw UncheckedException.throwAsUncheckedException((Throwable)exception);
        }
    }

    private boolean isMatch(Constructor<?> constructor, Object ... objectArray) {
        if (constructor.getParameterTypes().length != objectArray.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            Class<?> clazz = constructor.getParameterTypes()[i];
            if (!(clazz.isPrimitive() ? !ReflectionUtil.getWrapperTypeForPrimitiveType(clazz).isInstance(object) : object != null && !clazz.isInstance(object))) continue;
            return false;
        }
        return true;
    }
}

