/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.File;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.PluginModuleRegistry;
import org.gradle.api.internal.classpath.UnknownModuleException;
import org.gradle.util.ClassPath;
import org.gradle.util.DefaultClassPath;

public class DependencyClassPathProvider
implements ClassPathProvider {
    private final ModuleRegistry moduleRegistry;
    private final PluginModuleRegistry pluginModuleRegistry;

    public DependencyClassPathProvider(ModuleRegistry moduleRegistry, PluginModuleRegistry pluginModuleRegistry) {
        this.moduleRegistry = moduleRegistry;
        this.pluginModuleRegistry = pluginModuleRegistry;
    }

    public ClassPath findClassPath(String string) {
        if (string.equals(DependencyFactory.ClassPathNotation.GRADLE_API.name())) {
            ClassPath classPath = new DefaultClassPath(new File[0]);
            Module module = this.moduleRegistry.getModule("gradle-core");
            for (Module module2 : module.getAllRequiredModules()) {
                classPath = classPath.plus(module2.getClasspath());
            }
            classPath = classPath.plus(this.moduleRegistry.getModule("gradle-core-impl").getClasspath());
            try {
                classPath = classPath.plus(this.moduleRegistry.getModule("gradle-tooling-api").getImplementationClasspath());
            }
            catch (UnknownModuleException unknownModuleException) {
                // empty catch block
            }
            for (Module module2 : this.pluginModuleRegistry.getPluginModules()) {
                classPath = classPath.plus(module2.getClasspath());
            }
            return classPath;
        }
        if (string.equals(DependencyFactory.ClassPathNotation.LOCAL_GROOVY.name())) {
            return this.moduleRegistry.getExternalModule("groovy-all").getClasspath();
        }
        return null;
    }
}

