/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.Namer;
import org.gradle.api.internal.DefaultNamedDomainObjectCollection;
import org.gradle.api.internal.Instantiator;
import org.gradle.api.internal.collections.CollectionEventRegister;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.internal.collections.FilteredList;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNamedDomainObjectList<T>
extends DefaultNamedDomainObjectCollection<T>
implements NamedDomainObjectList<T> {
    public DefaultNamedDomainObjectList(DefaultNamedDomainObjectList<? super T> defaultNamedDomainObjectList, CollectionFilter<T> collectionFilter, Instantiator instantiator, Namer<? super T> namer) {
        super(defaultNamedDomainObjectList, collectionFilter, instantiator, namer);
    }

    public DefaultNamedDomainObjectList(Class<T> clazz, CollectionEventRegister<T> collectionEventRegister, Instantiator instantiator, Namer<? super T> namer) {
        super(clazz, new ArrayList(), collectionEventRegister, instantiator, namer);
    }

    public DefaultNamedDomainObjectList(Class<T> clazz, Instantiator instantiator, Namer<? super T> namer) {
        super(clazz, new ArrayList(), instantiator, namer);
    }

    @Override
    public void add(int n, T t) {
        this.assertMutable();
        this.assertCanAdd(t);
        this.getStore().add(n, t);
        this.getEventRegister().getAddAction().execute(t);
    }

    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        this.assertMutable();
        boolean bl = false;
        int n2 = n;
        for (T t : collection) {
            if (this.hasWithName(this.getNamer().determineName(t))) continue;
            this.getStore().add(n2, t);
            this.getEventRegister().getAddAction().execute(t);
            bl = true;
            ++n2;
        }
        return bl;
    }

    @Override
    protected List<T> getStore() {
        return (List)super.getStore();
    }

    @Override
    public T get(int n) {
        return (T)this.getStore().get(n);
    }

    @Override
    public T set(int n, T t) {
        this.assertMutable();
        this.assertCanAdd(t);
        T t2 = this.getStore().set(n, t);
        this.getEventRegister().getRemoveAction().execute(t2);
        this.getEventRegister().getAddAction().execute(t);
        return t2;
    }

    @Override
    public T remove(int n) {
        this.assertMutable();
        Object e = this.getStore().remove(n);
        this.getEventRegister().getRemoveAction().execute(e);
        return (T)e;
    }

    @Override
    public int indexOf(Object object) {
        return this.getStore().indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.getStore().lastIndexOf(object);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ListIteratorImpl(this.getStore().listIterator());
    }

    @Override
    public ListIterator<T> listIterator(int n) {
        return new ListIteratorImpl(this.getStore().listIterator(n));
    }

    @Override
    public List<T> subList(int n, int n2) {
        return Collections.unmodifiableList(this.getStore().subList(n, n2));
    }

    @Override
    protected <S extends T> Collection<S> filteredStore(CollectionFilter<S> collectionFilter) {
        return new FilteredList(this, collectionFilter);
    }

    @Override
    public NamedDomainObjectList<T> matching(Closure closure) {
        return this.matching(Specs.convertClosureToSpec(closure));
    }

    @Override
    public NamedDomainObjectList<T> matching(Spec<? super T> spec) {
        return new DefaultNamedDomainObjectList<T>(this, this.createFilter(spec), this.getInstantiator(), this.getNamer());
    }

    @Override
    public <S extends T> NamedDomainObjectList<S> withType(Class<S> clazz) {
        return new DefaultNamedDomainObjectList<S>(this, this.createFilter(clazz), this.getInstantiator(), this.getNamer());
    }

    @Override
    public List<T> findAll(Closure closure) {
        return this.findAll(closure, new ArrayList());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListIteratorImpl
    implements ListIterator<T> {
        private final ListIterator<T> iterator;
        private T lastElement;

        public ListIteratorImpl(ListIterator<T> listIterator) {
            this.iterator = listIterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public T next() {
            this.lastElement = this.iterator.next();
            return this.lastElement;
        }

        @Override
        public T previous() {
            this.lastElement = this.iterator.previous();
            return this.lastElement;
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void add(T t) {
            DefaultNamedDomainObjectList.this.assertMutable();
            DefaultNamedDomainObjectList.this.assertCanAdd(t);
            this.iterator.add(t);
            DefaultNamedDomainObjectList.this.getEventRegister().getAddAction().execute(t);
        }

        @Override
        public void remove() {
            DefaultNamedDomainObjectList.this.assertMutable();
            this.iterator.remove();
            DefaultNamedDomainObjectList.this.getEventRegister().getRemoveAction().execute(this.lastElement);
            this.lastElement = null;
        }

        @Override
        public void set(T t) {
            DefaultNamedDomainObjectList.this.assertMutable();
            DefaultNamedDomainObjectList.this.assertCanAdd(t);
            this.iterator.set(t);
            DefaultNamedDomainObjectList.this.getEventRegister().getRemoveAction().execute(this.lastElement);
            DefaultNamedDomainObjectList.this.getEventRegister().getAddAction().execute(t);
            this.lastElement = null;
        }
    }
}

