/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.Namer;
import org.gradle.api.Rule;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.internal.AbstractDynamicObject;
import org.gradle.api.internal.BeanDynamicObject;
import org.gradle.api.internal.CompositeDynamicObject;
import org.gradle.api.internal.DefaultDomainObjectCollection;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.ExtensibleDynamicObject;
import org.gradle.api.internal.Instantiator;
import org.gradle.api.internal.collections.CollectionEventRegister;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.internal.plugins.DefaultConvention;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNamedDomainObjectCollection<T>
extends DefaultDomainObjectCollection<T>
implements NamedDomainObjectCollection<T>,
DynamicObjectAware {
    private final Instantiator instantiator;
    private final Namer<? super T> namer;
    private final ContainerElementsDynamicObject elementsDynamicObject = new ContainerElementsDynamicObject();
    private final Convention convention;
    private final DynamicObject dynamicObject;
    private final List<Rule> rules = new ArrayList<Rule>();
    private Set<String> applyingRulesFor = new HashSet<String>();

    public DefaultNamedDomainObjectCollection(Class<? extends T> clazz, Collection<T> collection, Instantiator instantiator, Namer<? super T> namer) {
        super(clazz, collection);
        this.instantiator = instantiator;
        this.convention = new DefaultConvention(instantiator);
        this.dynamicObject = new ExtensibleDynamicObject((Object)this, (AbstractDynamicObject)new ContainerDynamicObject(this.elementsDynamicObject), this.convention);
        this.namer = namer;
    }

    protected DefaultNamedDomainObjectCollection(Class<? extends T> clazz, Collection<T> collection, CollectionEventRegister<T> collectionEventRegister, Instantiator instantiator, Namer<? super T> namer) {
        super(clazz, collection, collectionEventRegister);
        this.instantiator = instantiator;
        this.convention = new DefaultConvention(instantiator);
        this.dynamicObject = new ExtensibleDynamicObject((Object)this, (AbstractDynamicObject)new ContainerDynamicObject(this.elementsDynamicObject), this.convention);
        this.namer = namer;
    }

    public DefaultNamedDomainObjectCollection(DefaultNamedDomainObjectCollection<? super T> defaultNamedDomainObjectCollection, CollectionFilter<T> collectionFilter, Instantiator instantiator, Namer<? super T> namer) {
        this(collectionFilter.getType(), defaultNamedDomainObjectCollection.filteredStore(collectionFilter), defaultNamedDomainObjectCollection.filteredEvents(collectionFilter), instantiator, namer);
    }

    @Override
    public boolean add(T t) {
        if (!this.hasWithName(this.namer.determineName(t))) {
            return super.add(t);
        }
        this.handleAttemptToAddItemWithNonUniqueName(t);
        return false;
    }

    protected void handleAttemptToAddItemWithNonUniqueName(T t) {
    }

    protected void assertCanAdd(String string) {
        if (this.hasWithName(string)) {
            throw new InvalidUserDataException(String.format("Cannot add a %s with name '%s' as a %s with that name already exists.", this.getTypeDisplayName(), string, this.getTypeDisplayName()));
        }
    }

    protected void assertCanAdd(T t) {
        this.assertCanAdd(this.getNamer().determineName(t));
    }

    @Override
    public Namer<T> getNamer() {
        return this.namer;
    }

    protected Instantiator getInstantiator() {
        return this.instantiator;
    }

    @Override
    protected <S extends T> DefaultNamedDomainObjectCollection<S> filtered(CollectionFilter<S> collectionFilter) {
        return this.instantiator.newInstance(DefaultNamedDomainObjectCollection.class, this, collectionFilter, this.instantiator, this.namer);
    }

    public String getDisplayName() {
        return String.format("%s container", this.getTypeDisplayName());
    }

    @Override
    public SortedMap<String, T> getAsMap() {
        TreeMap treeMap = new TreeMap();
        for (Object t : this.getStore()) {
            treeMap.put(this.namer.determineName(t), t);
        }
        return treeMap;
    }

    @Override
    public <S extends T> NamedDomainObjectCollection<S> withType(Class<S> clazz) {
        return this.filtered((CollectionFilter)this.createFilter(clazz));
    }

    @Override
    public NamedDomainObjectCollection<T> matching(Spec<? super T> spec) {
        return this.filtered(this.createFilter(spec));
    }

    @Override
    public NamedDomainObjectCollection<T> matching(Closure closure) {
        return this.matching(Specs.convertClosureToSpec(closure));
    }

    @Override
    public T findByName(String string) {
        T t = this.findByNameWithoutRules(string);
        if (t != null) {
            return t;
        }
        this.applyRules(string);
        return this.findByNameWithoutRules(string);
    }

    protected boolean hasWithName(String string) {
        return this.findByNameWithoutRules(string) != null;
    }

    protected T findByNameWithoutRules(String string) {
        for (Object t : this.getStore()) {
            if (!string.equals(this.namer.determineName(t))) continue;
            return t;
        }
        return null;
    }

    protected T removeByName(String string) {
        T t = this.getByName(string);
        if (t != null) {
            if (this.remove(t)) {
                return t;
            }
            throw new IllegalStateException(String.format("found '%s' with name '%s' but remove() returned false", t, string));
        }
        return null;
    }

    @Override
    public T getByName(String string) throws UnknownDomainObjectException {
        T t = this.findByName(string);
        if (t == null) {
            throw this.createNotFoundException(string);
        }
        return t;
    }

    @Override
    public T getByName(String string, Closure closure) throws UnknownDomainObjectException {
        T t = this.getByName(string);
        ConfigureUtil.configure(closure, t);
        return t;
    }

    @Override
    public T getAt(String string) throws UnknownDomainObjectException {
        return this.getByName(string);
    }

    @Override
    public DynamicObject getAsDynamicObject() {
        return this.dynamicObject;
    }

    public Convention getConvention() {
        return this.convention;
    }

    public ExtensionContainer getExtensions() {
        return this.convention;
    }

    protected DynamicObject getElementsAsDynamicObject() {
        return this.elementsDynamicObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyRules(String string) {
        if (this.applyingRulesFor.contains(string)) {
            return;
        }
        this.applyingRulesFor.add(string);
        try {
            for (Rule rule : this.rules) {
                rule.apply(string);
            }
        }
        finally {
            this.applyingRulesFor.remove(string);
        }
    }

    @Override
    public Rule addRule(Rule rule) {
        this.rules.add(rule);
        return rule;
    }

    @Override
    public Rule addRule(final String string, final Closure closure) {
        Rule rule = new Rule(){

            public String getDescription() {
                return string;
            }

            public void apply(String string2) {
                closure.call((Object)string2);
            }

            public String toString() {
                return "Rule: " + string;
            }
        };
        this.rules.add(rule);
        return rule;
    }

    @Override
    public List<Rule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    protected UnknownDomainObjectException createNotFoundException(String string) {
        return new UnknownDomainObjectException(String.format("%s with name '%s' not found.", this.getTypeDisplayName(), string));
    }

    protected String getTypeDisplayName() {
        return this.getType().getSimpleName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContainerElementsDynamicObject
    extends AbstractDynamicObject {
        private ContainerElementsDynamicObject() {
        }

        @Override
        protected String getDisplayName() {
            return DefaultNamedDomainObjectCollection.this.getDisplayName();
        }

        @Override
        public boolean hasProperty(String string) {
            return DefaultNamedDomainObjectCollection.this.findByName(string) != null;
        }

        public T getProperty(String string) throws MissingPropertyException {
            Object t = DefaultNamedDomainObjectCollection.this.findByName(string);
            if (t == null) {
                return super.getProperty(string);
            }
            return t;
        }

        public Map<String, T> getProperties() {
            return DefaultNamedDomainObjectCollection.this.getAsMap();
        }

        @Override
        public boolean hasMethod(String string, Object ... objectArray) {
            return this.isConfigureMethod(string, objectArray);
        }

        @Override
        public Object invokeMethod(String string, Object ... objectArray) throws MissingMethodException {
            if (this.isConfigureMethod(string, objectArray)) {
                return ConfigureUtil.configure((Closure)objectArray[0], DefaultNamedDomainObjectCollection.this.getByName(string));
            }
            return super.invokeMethod(string, objectArray);
        }

        private boolean isConfigureMethod(String string, Object ... objectArray) {
            return objectArray.length == 1 && objectArray[0] instanceof Closure && this.hasProperty(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContainerDynamicObject
    extends CompositeDynamicObject {
        private ContainerDynamicObject(ContainerElementsDynamicObject containerElementsDynamicObject) {
            this.setObjects(new BeanDynamicObject(DefaultNamedDomainObjectCollection.this), containerElementsDynamicObject, DefaultNamedDomainObjectCollection.this.convention.getExtensionsAsDynamicObject());
        }

        @Override
        protected String getDisplayName() {
            return DefaultNamedDomainObjectCollection.this.getDisplayName();
        }
    }
}

