/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.internal.collections.CollectionEventRegister;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.internal.collections.FilteredCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDomainObjectCollection<T>
extends AbstractCollection<T>
implements DomainObjectCollection<T> {
    private final Class<? extends T> type;
    private final CollectionEventRegister<T> eventRegister;
    private final Collection<T> store;
    private final Set<Runnable> mutateActions = new LinkedHashSet<Runnable>();

    public DefaultDomainObjectCollection(Class<? extends T> clazz, Collection<T> collection) {
        this(clazz, collection, new CollectionEventRegister());
    }

    protected DefaultDomainObjectCollection(Class<? extends T> clazz, Collection<T> collection, CollectionEventRegister<T> collectionEventRegister) {
        this.type = clazz;
        this.store = collection;
        this.eventRegister = collectionEventRegister;
    }

    protected DefaultDomainObjectCollection(DefaultDomainObjectCollection<? super T> defaultDomainObjectCollection, CollectionFilter<T> collectionFilter) {
        this(collectionFilter.getType(), defaultDomainObjectCollection.filteredStore(collectionFilter), defaultDomainObjectCollection.filteredEvents(collectionFilter));
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    protected Collection<T> getStore() {
        return this.store;
    }

    protected CollectionEventRegister<T> getEventRegister() {
        return this.eventRegister;
    }

    protected CollectionFilter<T> createFilter(Spec<? super T> spec) {
        return this.createFilter(this.getType(), spec);
    }

    protected <S extends T> CollectionFilter<S> createFilter(Class<S> clazz) {
        return new CollectionFilter<S>(clazz);
    }

    protected <S extends T> CollectionFilter<S> createFilter(Class<? extends S> clazz, Spec<? super S> spec) {
        return new CollectionFilter<S>(clazz, spec);
    }

    protected <S extends T> DefaultDomainObjectCollection<S> filtered(CollectionFilter<S> collectionFilter) {
        return new DefaultDomainObjectCollection<S>(this, collectionFilter);
    }

    protected <S extends T> Collection<S> filteredStore(CollectionFilter<S> collectionFilter) {
        return new FilteredCollection(this, collectionFilter);
    }

    protected <S extends T> CollectionEventRegister<S> filteredEvents(CollectionFilter<S> collectionFilter) {
        return this.getEventRegister().filtered(collectionFilter);
    }

    @Override
    public DomainObjectCollection<T> matching(Spec<? super T> spec) {
        return this.filtered(this.createFilter(spec));
    }

    @Override
    public DomainObjectCollection<T> matching(Closure closure) {
        return this.matching(Specs.convertClosureToSpec(closure));
    }

    @Override
    public <S extends T> DomainObjectCollection<S> withType(Class<S> clazz) {
        return this.filtered(this.createFilter(clazz));
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorImpl(this.getStore().iterator());
    }

    @Override
    public void all(Action<? super T> action) {
        action = this.whenObjectAdded(action);
        LinkedList linkedList = new LinkedList(this);
        for (Object e : linkedList) {
            action.execute(e);
        }
    }

    @Override
    public void all(Closure closure) {
        this.all(this.toAction(closure));
    }

    @Override
    public <S extends T> DomainObjectCollection<S> withType(Class<S> clazz, Action<? super S> action) {
        DomainObjectCollection<S> domainObjectCollection = this.withType(clazz);
        domainObjectCollection.all(action);
        return domainObjectCollection;
    }

    @Override
    public <S extends T> DomainObjectCollection<S> withType(Class<S> clazz, Closure closure) {
        DomainObjectCollection<S> domainObjectCollection = this.withType(clazz);
        domainObjectCollection.all(closure);
        return domainObjectCollection;
    }

    @Override
    public Action<? super T> whenObjectAdded(Action<? super T> action) {
        return this.eventRegister.registerAddAction(action);
    }

    @Override
    public Action<? super T> whenObjectRemoved(Action<? super T> action) {
        return this.eventRegister.registerRemoveAction(action);
    }

    @Override
    public void whenObjectAdded(Closure closure) {
        this.whenObjectAdded(this.toAction(closure));
    }

    @Override
    public void whenObjectRemoved(Closure closure) {
        this.whenObjectRemoved(this.toAction(closure));
    }

    public void beforeChange(Runnable runnable) {
        this.mutateActions.add(runnable);
    }

    private Action<? super T> toAction(final Closure closure) {
        return new Action<T>(){

            @Override
            public void execute(T t) {
                ConfigureUtil.configure(closure, t);
            }
        };
    }

    @Override
    public boolean add(T t) {
        this.assertMutable();
        return this.doAdd(t);
    }

    private boolean doAdd(T t) {
        if (this.getStore().add(t)) {
            this.eventRegister.getAddAction().execute(t);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        this.assertMutable();
        boolean bl = false;
        for (T t : collection) {
            if (!this.doAdd(t)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear() {
        this.assertMutable();
        Object[] objectArray = this.toArray();
        this.getStore().clear();
        for (Object object : objectArray) {
            this.eventRegister.getRemoveAction().execute(object);
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.getStore().contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.getStore().containsAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.getStore().isEmpty();
    }

    @Override
    public boolean remove(Object object) {
        this.assertMutable();
        return this.doRemove(object);
    }

    private boolean doRemove(Object object) {
        if (this.getStore().remove(object)) {
            this.eventRegister.getRemoveAction().execute(object);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.assertMutable();
        boolean bl = false;
        for (Object obj : collection) {
            if (!this.doRemove(obj)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.assertMutable();
        Object[] objectArray = this.toArray();
        boolean bl = false;
        for (Object object : objectArray) {
            if (collection.contains(object)) continue;
            this.doRemove(object);
            bl = true;
        }
        return bl;
    }

    @Override
    public int size() {
        return this.getStore().size();
    }

    @Override
    public Collection<T> findAll(Closure closure) {
        return this.findAll(closure, new ArrayList());
    }

    protected <S extends Collection<? super T>> S findAll(Closure closure, S s) {
        for (Object t : this.filteredStore(this.createFilter(Specs.convertClosureToSpec(closure)))) {
            s.add(t);
        }
        return s;
    }

    protected void assertMutable() {
        for (Runnable runnable : this.mutateActions) {
            runnable.run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorImpl
    implements Iterator<T> {
        private final Iterator<T> iterator;
        private T currentElement;

        public IteratorImpl(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            this.currentElement = this.iterator.next();
            return this.currentElement;
        }

        @Override
        public void remove() {
            DefaultDomainObjectCollection.this.assertMutable();
            this.iterator.remove();
            DefaultDomainObjectCollection.this.getEventRegister().getRemoveAction().execute(this.currentElement);
            this.currentElement = null;
        }
    }
}

