/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.util.ClassPath;

public class DefaultClassPathRegistry
implements ClassPathRegistry {
    private final List<ClassPathProvider> providers = new ArrayList<ClassPathProvider>();

    public DefaultClassPathRegistry(ClassPathProvider ... classPathProviderArray) {
        this.providers.addAll(Arrays.asList(classPathProviderArray));
    }

    public ClassPath getClassPath(String string) {
        for (ClassPathProvider classPathProvider : this.providers) {
            ClassPath classPath = classPathProvider.findClassPath(string);
            if (classPath == null) continue;
            return classPath;
        }
        throw new IllegalArgumentException(String.format("unknown classpath '%s' requested.", string));
    }
}

