/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.File;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.util.ClassPath;
import org.gradle.util.DefaultClassPath;

public class DefaultClassPathProvider
implements ClassPathProvider {
    private final ModuleRegistry moduleRegistry;

    public DefaultClassPathProvider(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
    }

    public ClassPath findClassPath(String string) {
        if (string.equals("GRADLE_RUNTIME")) {
            ClassPath classPath = new DefaultClassPath(new File[0]);
            for (Module module : this.moduleRegistry.getModule("gradle-launcher").getAllRequiredModules()) {
                classPath = classPath.plus(module.getClasspath());
            }
            return classPath;
        }
        if (string.equals("GRADLE_CORE")) {
            return this.moduleRegistry.getModule("gradle-core").getImplementationClasspath();
        }
        if (string.equals("COMMONS_CLI")) {
            return this.moduleRegistry.getExternalModule("commons-cli").getClasspath();
        }
        if (string.equals("ANT")) {
            ClassPath classPath = new DefaultClassPath(new File[0]);
            classPath = classPath.plus(this.moduleRegistry.getExternalModule("ant").getClasspath());
            classPath = classPath.plus(this.moduleRegistry.getExternalModule("ant-launcher").getClasspath());
            return classPath;
        }
        if (string.equals("GROOVY")) {
            return this.moduleRegistry.getExternalModule("groovy-all").getClasspath();
        }
        return null;
    }
}

