/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.plugins.DefaultConvention;
import org.gradle.api.plugins.Convention;
import org.gradle.internal.UncheckedException;
import org.gradle.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConventionAwareHelper
implements ConventionMapping,
HasConvention {
    private Convention convention;
    private IConventionAware source;
    private Map<String, MappedPropertyImpl> mappings = new HashMap<String, MappedPropertyImpl>();

    public ConventionAwareHelper(IConventionAware iConventionAware) {
        this.source = iConventionAware;
        this.convention = new DefaultConvention();
    }

    public ConventionAwareHelper(IConventionAware iConventionAware, Convention convention) {
        this.source = iConventionAware;
        this.convention = convention;
    }

    private ConventionMapping.MappedProperty map(String string, Value<?> value) {
        if (!ReflectionUtil.hasProperty(this.source, string)) {
            throw new InvalidUserDataException("You can't map a property that does not exist: propertyName=" + string);
        }
        MappedPropertyImpl mappedPropertyImpl = new MappedPropertyImpl(value);
        this.mappings.put(string, mappedPropertyImpl);
        return mappedPropertyImpl;
    }

    @Override
    public ConventionMapping.MappedProperty map(String string, final Closure<?> closure) {
        return this.map(string, new Value<Object>(){

            @Override
            public Object getValue(Convention convention, IConventionAware iConventionAware) {
                switch (closure.getMaximumNumberOfParameters()) {
                    case 0: {
                        return closure.call();
                    }
                    case 1: {
                        return closure.call((Object)convention);
                    }
                }
                return closure.call(new Object[]{convention, iConventionAware});
            }
        });
    }

    @Override
    public ConventionMapping.MappedProperty map(String string, final Callable<?> callable) {
        return this.map(string, new Value<Object>(){

            @Override
            public Object getValue(Convention convention, IConventionAware iConventionAware) {
                try {
                    return callable.call();
                }
                catch (Exception exception) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)exception);
                }
            }
        });
    }

    public void propertyMissing(String string, Object object) {
        if (!(object instanceof Closure)) {
            throw new MissingPropertyException(string, this.getClass());
        }
        this.map(string, (Closure)object);
    }

    @Override
    public <T> T getConventionValue(T t, String string, boolean bl) {
        if (bl) {
            return t;
        }
        Object object = t;
        if (this.mappings.containsKey(string)) {
            boolean bl2 = true;
            if (t instanceof Collection && !((Collection)t).isEmpty()) {
                bl2 = false;
            } else if (t instanceof Map && !((Map)t).isEmpty()) {
                bl2 = false;
            }
            if (bl2) {
                object = this.mappings.get(string).getValue(this.convention, this.source);
            }
        }
        return object;
    }

    @Override
    public Convention getConvention() {
        return this.convention;
    }

    public IConventionAware getSource() {
        return this.source;
    }

    public void setSource(IConventionAware iConventionAware) {
        this.source = iConventionAware;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MappedPropertyImpl
    implements ConventionMapping.MappedProperty {
        private final Value<?> value;
        private boolean haveValue;
        private boolean cache;
        private Object cachedValue;

        private MappedPropertyImpl(Value<?> value) {
            this.value = value;
        }

        public Object getValue(Convention convention, IConventionAware iConventionAware) {
            if (!this.cache) {
                return this.value.getValue(convention, iConventionAware);
            }
            if (!this.haveValue) {
                this.cachedValue = this.value.getValue(convention, iConventionAware);
                this.haveValue = true;
            }
            return this.cachedValue;
        }

        @Override
        public void cache() {
            this.cache = true;
            this.cachedValue = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Value<T> {
        public T getValue(Convention var1, IConventionAware var2);
    }
}

