/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.AbstractDynamicObject;
import org.gradle.api.internal.DynamicObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeDynamicObject
extends AbstractDynamicObject {
    private DynamicObject[] objects = new DynamicObject[0];
    private DynamicObject[] updateObjects = new DynamicObject[0];

    protected void setObjects(DynamicObject ... dynamicObjectArray) {
        this.objects = dynamicObjectArray;
        this.updateObjects = dynamicObjectArray;
    }

    protected void setObjectsForUpdate(DynamicObject ... dynamicObjectArray) {
        this.updateObjects = dynamicObjectArray;
    }

    @Override
    public boolean hasProperty(String string) {
        for (DynamicObject dynamicObject : this.objects) {
            if (!dynamicObject.hasProperty(string)) continue;
            return true;
        }
        return super.hasProperty(string);
    }

    @Override
    public Object getProperty(String string) throws MissingPropertyException {
        for (DynamicObject dynamicObject : this.objects) {
            if (!dynamicObject.hasProperty(string)) continue;
            return dynamicObject.getProperty(string);
        }
        return super.getProperty(string);
    }

    @Override
    public void setProperty(String string, Object object) throws MissingPropertyException {
        for (DynamicObject dynamicObject : this.updateObjects) {
            if (!dynamicObject.hasProperty(string)) continue;
            dynamicObject.setProperty(string, object);
            return;
        }
        this.updateObjects[this.updateObjects.length - 1].setProperty(string, object);
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = this.objects.length - 1; i >= 0; --i) {
            DynamicObject dynamicObject = this.objects[i];
            hashMap.putAll(dynamicObject.getProperties());
        }
        hashMap.put("properties", hashMap);
        return hashMap;
    }

    @Override
    public boolean hasMethod(String string, Object ... objectArray) {
        for (DynamicObject dynamicObject : this.objects) {
            if (!dynamicObject.hasMethod(string, objectArray)) continue;
            return true;
        }
        return super.hasMethod(string, objectArray);
    }

    @Override
    public Object invokeMethod(String string, Object ... objectArray) throws MissingMethodException {
        Object object = this.objects;
        int n = ((DynamicObject[])object).length;
        for (int i = 0; i < n; ++i) {
            DynamicObject dynamicObject = object[i];
            if (!dynamicObject.hasMethod(string, objectArray)) continue;
            return dynamicObject.invokeMethod(string, objectArray);
        }
        if (this.hasProperty(string) && (object = this.getProperty(string)) instanceof Closure) {
            Closure closure = (Closure)object;
            closure.setResolveStrategy(1);
            return closure.call(objectArray);
        }
        return super.invokeMethod(string, objectArray);
    }
}

