/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.commons.collections.collection.CompositeCollection;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.FilteredAction;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDomainObjectSet<T>
extends DefaultDomainObjectSet<T> {
    private Spec<T> uniqueSpec = new ItemIsUniqueInCompositeSpec();
    private Spec<T> notInSpec = new ItemNotInCompositeSpec();

    public CompositeDomainObjectSet(Class<T> clazz) {
        super(clazz, new CompositeCollection());
    }

    public CompositeDomainObjectSet(Class<T> clazz, DomainObjectCollection<? extends T> ... domainObjectCollectionArray) {
        this((Class<? extends T>)clazz);
        for (DomainObjectCollection<? extends T> domainObjectCollection : domainObjectCollectionArray) {
            this.addCollection(domainObjectCollection);
        }
    }

    protected CompositeCollection getStore() {
        return (CompositeCollection)super.getStore();
    }

    @Override
    public Action<? super T> whenObjectAdded(Action<? super T> action) {
        return super.whenObjectAdded(new FilteredAction<T>(this.uniqueSpec, action));
    }

    @Override
    public Action<? super T> whenObjectRemoved(Action<? super T> action) {
        return super.whenObjectRemoved(new FilteredAction<T>(this.notInSpec, action));
    }

    public void addCollection(DomainObjectCollection<? extends T> domainObjectCollection) {
        this.getStore().addComposited(domainObjectCollection);
        domainObjectCollection.all(this.getEventRegister().getAddAction());
        domainObjectCollection.whenObjectRemoved(this.getEventRegister().getRemoveAction());
    }

    public void removeCollection(DomainObjectCollection<? extends T> domainObjectCollection) {
        this.getStore().removeComposited(domainObjectCollection);
        Action action = this.getEventRegister().getRemoveAction();
        for (Object e : domainObjectCollection) {
            action.execute(e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new LinkedHashSet(this.getStore()).iterator();
    }

    @Override
    public int size() {
        return new LinkedHashSet(this.getStore()).size();
    }

    @Override
    public void all(Action<? super T> action) {
        this.whenObjectAdded(action);
        for (T t : this) {
            action.execute(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemNotInCompositeSpec
    implements Spec<T> {
        @Override
        public boolean isSatisfiedBy(T t) {
            return !CompositeDomainObjectSet.this.getStore().contains(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemIsUniqueInCompositeSpec
    implements Spec<T> {
        @Override
        public boolean isSatisfiedBy(T t) {
            int n = 0;
            for (Object e : CompositeDomainObjectSet.this.getStore().getCollections()) {
                if (!((Collection)e).contains(t) || ++n <= 1) continue;
                return false;
            }
            return true;
        }
    }
}

