/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.GString;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingTransformer<T>
implements Transformer<T, T> {
    private final List<Transformer<T, T>> transformers = new ArrayList<Transformer<T, T>>();
    private final Class<T> type;

    public ChainingTransformer(Class<T> clazz) {
        this.type = clazz;
    }

    @Override
    public T transform(T t) {
        T t2 = t;
        for (Transformer<T, T> transformer : this.transformers) {
            t2 = this.type.cast(transformer.transform(t2));
        }
        return t2;
    }

    public void add(Transformer<T, T> transformer) {
        this.transformers.add(transformer);
    }

    public void add(final Closure closure) {
        this.transformers.add(new Transformer<T, T>(){

            @Override
            public T transform(T t) {
                closure.setDelegate(t);
                closure.setResolveStrategy(1);
                Object object = closure.call(t);
                if (ChainingTransformer.this.type.isInstance(object)) {
                    return ChainingTransformer.this.type.cast(object);
                }
                if (ChainingTransformer.this.type == String.class && object instanceof GString) {
                    return ChainingTransformer.this.type.cast(object.toString());
                }
                return t;
            }
        });
    }

    public boolean hasTransformers() {
        return !this.transformers.isEmpty();
    }
}

