/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.DirectedGraph;
import org.gradle.api.internal.DirectedGraphWithEdgeValues;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingDirectedGraphWalker<N, T> {
    private final DirectedGraphWithEdgeValues<N, T> graph;
    private List<N> startNodes = new LinkedList<N>();
    private final Map<N, Set<T>> cachedNodeValues = new HashMap<N, Set<T>>();

    public CachingDirectedGraphWalker(DirectedGraph<N, T> directedGraph) {
        this.graph = new GraphWithEmpyEdges<N, T>(directedGraph);
    }

    public CachingDirectedGraphWalker(DirectedGraphWithEdgeValues<N, T> directedGraphWithEdgeValues) {
        this.graph = directedGraphWithEdgeValues;
    }

    public CachingDirectedGraphWalker<N, T> add(N ... NArray) {
        this.add((Iterable<? extends N>)Arrays.asList(NArray));
        return this;
    }

    public CachingDirectedGraphWalker add(Iterable<? extends N> iterable) {
        GUtil.addToCollection(this.startNodes, iterable);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> findValues() {
        try {
            Set<T> set = this.doSearch();
            return set;
        }
        finally {
            this.startNodes.clear();
        }
    }

    private Set<T> doSearch() {
        Object object;
        int n = 0;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        LinkedList<N> linkedList = new LinkedList<N>(this.startNodes);
        while (!linkedList.isEmpty()) {
            Object object2;
            object = linkedList.getFirst();
            NodeDetails nodeDetails = (NodeDetails)hashMap.get(object);
            if (nodeDetails == null) {
                nodeDetails = new NodeDetails(object, n++);
                hashMap.put(object, nodeDetails);
                hashMap2.put(nodeDetails.component, nodeDetails);
                object2 = this.cachedNodeValues.get(object);
                if (object2 != null) {
                    nodeDetails.values = (Set)object2;
                    nodeDetails.finished = true;
                    linkedList.removeFirst();
                    continue;
                }
                this.graph.getNodeValues(object, nodeDetails.values, nodeDetails.successors);
                for (NodeDetails nodeDetails2 : nodeDetails.successors) {
                    if (hashMap.containsKey(nodeDetails2)) continue;
                    linkedList.add(0, nodeDetails2);
                }
                continue;
            }
            linkedList.removeFirst();
            if (this.cachedNodeValues.containsKey(object)) continue;
            for (Object object3 : nodeDetails.successors) {
                NodeDetails nodeDetails2;
                nodeDetails2 = (NodeDetails)hashMap.get(object3);
                if (!nodeDetails2.finished) {
                    nodeDetails.minSeen = Math.min(nodeDetails.minSeen, nodeDetails2.minSeen);
                }
                nodeDetails.values.addAll(nodeDetails2.values);
                this.graph.getEdgeValues(object, object3, nodeDetails.values);
            }
            if (nodeDetails.minSeen != nodeDetails.component) {
                object2 = (NodeDetails)hashMap2.get(nodeDetails.minSeen);
                ((NodeDetails)object2).values.addAll(nodeDetails.values);
                nodeDetails.values.clear();
                ((NodeDetails)object2).strongComponentMembers.addAll(nodeDetails.strongComponentMembers);
                continue;
            }
            for (Object object3 : nodeDetails.strongComponentMembers) {
                this.cachedNodeValues.put(((NodeDetails)object3).node, nodeDetails.values);
                ((NodeDetails)object3).finished = true;
                hashMap2.remove(((NodeDetails)object3).component);
            }
        }
        object = new LinkedHashSet();
        for (Object object2 : this.startNodes) {
            object.addAll((Collection)this.cachedNodeValues.get(object2));
        }
        return object;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GraphWithEmpyEdges<N, T>
    implements DirectedGraphWithEdgeValues<N, T> {
        private final DirectedGraph<N, T> graph;

        public GraphWithEmpyEdges(DirectedGraph<N, T> directedGraph) {
            this.graph = directedGraph;
        }

        @Override
        public void getEdgeValues(N n, N n2, Collection<T> collection) {
        }

        @Override
        public void getNodeValues(N n, Collection<T> collection, Collection<N> collection2) {
            this.graph.getNodeValues(n, collection, collection2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeDetails<N, T> {
        private final int component;
        private final N node;
        private Set<T> values = new LinkedHashSet<T>();
        private List<N> successors = new ArrayList<N>();
        private Set<NodeDetails<N, T>> strongComponentMembers = new LinkedHashSet<NodeDetails<N, T>>();
        private int minSeen;
        private boolean finished;

        public NodeDetails(N n, int n2) {
            this.node = n;
            this.component = n2;
            this.minSeen = n2;
            this.strongComponentMembers.add(this);
        }
    }
}

