/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaClass;
import groovy.lang.MetaProperty;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.ReadOnlyPropertyException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.gradle.api.internal.AbstractDynamicObject;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.DynamicObjectAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDynamicObject
extends AbstractDynamicObject {
    private final Object bean;
    private final boolean includeProperties;
    private final DynamicObject delegate;

    public BeanDynamicObject(Object object) {
        this(object, true);
    }

    private BeanDynamicObject(Object object, boolean bl) {
        this.bean = object;
        this.includeProperties = bl;
        this.delegate = this.determineDelegate(object);
    }

    public DynamicObject determineDelegate(Object object) {
        if (object instanceof DynamicObject || object instanceof DynamicObjectAware || !(object instanceof GroovyObject)) {
            return new MetaClassAdapter();
        }
        return new GroovyObjectAdapter();
    }

    public BeanDynamicObject withNoProperties() {
        return new BeanDynamicObject(this.bean, false);
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    protected String getDisplayName() {
        return this.bean.toString();
    }

    private MetaClass getMetaClass() {
        if (this.bean instanceof GroovyObject) {
            return ((GroovyObject)this.bean).getMetaClass();
        }
        return GroovySystem.getMetaClassRegistry().getMetaClass(this.bean.getClass());
    }

    @Override
    public boolean hasProperty(String string) {
        return this.delegate.hasProperty(string);
    }

    @Override
    public Object getProperty(String string) throws MissingPropertyException {
        return this.delegate.getProperty(string);
    }

    @Override
    public void setProperty(String string, Object object) throws MissingPropertyException {
        this.delegate.setProperty(string, object);
    }

    @Override
    public Map<String, ?> getProperties() {
        return this.delegate.getProperties();
    }

    @Override
    public boolean hasMethod(String string, Object ... objectArray) {
        return this.delegate.hasMethod(string, objectArray);
    }

    @Override
    public Object invokeMethod(String string, Object ... objectArray) throws MissingMethodException {
        return this.delegate.invokeMethod(string, objectArray);
    }

    private class GroovyObjectAdapter
    extends MetaClassAdapter {
        private final GroovyObject groovyObject;

        private GroovyObjectAdapter() {
            this.groovyObject = (GroovyObject)BeanDynamicObject.this.bean;
        }

        public Object getProperty(String string) throws MissingPropertyException {
            return this.groovyObject.getProperty(string);
        }

        public void setProperty(String string, Object object) throws MissingPropertyException {
            this.groovyObject.setProperty(string, object);
        }

        public Object invokeMethod(String string, Object ... objectArray) throws MissingMethodException {
            try {
                return this.groovyObject.invokeMethod(string, (Object)objectArray);
            }
            catch (InvokerInvocationException invokerInvocationException) {
                if (invokerInvocationException.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)invokerInvocationException.getCause();
                }
                throw invokerInvocationException;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MetaClassAdapter
    implements DynamicObject {
        private MetaClassAdapter() {
        }

        @Override
        public boolean hasProperty(String string) {
            return BeanDynamicObject.this.includeProperties && BeanDynamicObject.this.getMetaClass().hasProperty(BeanDynamicObject.this.bean, string) != null;
        }

        @Override
        public Object getProperty(String string) throws MissingPropertyException {
            if (!BeanDynamicObject.this.includeProperties) {
                throw BeanDynamicObject.this.propertyMissingException(string);
            }
            MetaProperty metaProperty = BeanDynamicObject.this.getMetaClass().hasProperty(BeanDynamicObject.this.bean, string);
            if (metaProperty == null) {
                return BeanDynamicObject.this.getMetaClass().invokeMissingProperty(BeanDynamicObject.this.bean, string, null, true);
            }
            if (metaProperty instanceof MetaBeanProperty && ((MetaBeanProperty)metaProperty).getGetter() == null) {
                throw new GroovyRuntimeException(String.format("Cannot get the value of write-only property '%s' on %s.", string, BeanDynamicObject.this.getDisplayName()));
            }
            try {
                return metaProperty.getProperty(BeanDynamicObject.this.bean);
            }
            catch (InvokerInvocationException invokerInvocationException) {
                if (invokerInvocationException.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)invokerInvocationException.getCause();
                }
                throw invokerInvocationException;
            }
        }

        @Override
        public void setProperty(final String string, Object object) throws MissingPropertyException {
            if (!BeanDynamicObject.this.includeProperties) {
                throw BeanDynamicObject.this.propertyMissingException(string);
            }
            MetaClass metaClass = BeanDynamicObject.this.getMetaClass();
            MetaProperty metaProperty = metaClass.hasProperty(BeanDynamicObject.this.bean, string);
            if (metaProperty == null && metaProperty == null) {
                BeanDynamicObject.this.getMetaClass().invokeMissingProperty(BeanDynamicObject.this.bean, string, null, false);
            }
            if (metaProperty instanceof MetaBeanProperty && ((MetaBeanProperty)metaProperty).getSetter() == null) {
                throw new ReadOnlyPropertyException(string, BeanDynamicObject.this.bean.getClass()){

                    public String getMessage() {
                        return String.format("Cannot set the value of read-only property '%s' on %s.", string, BeanDynamicObject.this.getDisplayName());
                    }
                };
            }
            try {
                metaClass.setProperty(BeanDynamicObject.this.bean, string, object);
            }
            catch (InvokerInvocationException invokerInvocationException) {
                if (invokerInvocationException.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)invokerInvocationException.getCause();
                }
                throw invokerInvocationException;
            }
        }

        @Override
        public Map<String, ?> getProperties() {
            if (!BeanDynamicObject.this.includeProperties) {
                return Collections.emptyMap();
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            List list = BeanDynamicObject.this.getMetaClass().getProperties();
            for (MetaProperty metaProperty : list) {
                MetaBeanProperty metaBeanProperty;
                if (metaProperty.getName().equals("properties")) {
                    hashMap.put("properties", hashMap);
                    continue;
                }
                if (metaProperty instanceof MetaBeanProperty && (metaBeanProperty = (MetaBeanProperty)metaProperty).getGetter() == null) continue;
                hashMap.put(metaProperty.getName(), metaProperty.getProperty(BeanDynamicObject.this.bean));
            }
            return hashMap;
        }

        @Override
        public boolean hasMethod(String string, Object ... objectArray) {
            return !BeanDynamicObject.this.getMetaClass().respondsTo(BeanDynamicObject.this.bean, string, objectArray).isEmpty();
        }

        @Override
        public Object invokeMethod(String string, Object ... objectArray) throws MissingMethodException {
            try {
                return BeanDynamicObject.this.getMetaClass().invokeMethod(BeanDynamicObject.this.bean, string, objectArray);
            }
            catch (InvokerInvocationException invokerInvocationException) {
                if (invokerInvocationException.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)invokerInvocationException.getCause();
                }
                throw invokerInvocationException;
            }
            catch (MissingMethodException missingMethodException) {
                throw BeanDynamicObject.this.methodMissingException(string, objectArray);
            }
        }
    }
}

