/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.DynamicObjectHelper;
import org.gradle.api.internal.ExtensibleDynamicObject;
import org.gradle.api.internal.Instantiator;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.TaskValidator;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.LoggingManager;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.TaskInstantiationException;
import org.gradle.api.tasks.TaskState;
import org.gradle.internal.Factory;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.StandardOutputCapture;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTask
implements TaskInternal,
DynamicObjectAware {
    private static Logger buildLogger = Logging.getLogger(Task.class);
    private static ThreadLocal<TaskInfo> nextInstance = new ThreadLocal();
    private ProjectInternal project;
    private String name;
    private List<Action<? super Task>> actions = new ArrayList<Action<? super Task>>();
    private String path;
    private boolean enabled = true;
    private DefaultTaskDependency dependencies;
    private ExtensibleDynamicObject extensibleDynamicObject;
    private String description;
    private String group;
    private AndSpec<Task> onlyIfSpec = new AndSpec(this.createNewOnlyIfSpec());
    private final TaskOutputsInternal outputs;
    private final TaskInputs inputs;
    private TaskExecuter executer;
    private final ServiceRegistry services;
    private final TaskStateInternal state;
    private final LoggingManagerInternal loggingManager;
    private List<TaskValidator> validators = new ArrayList<TaskValidator>();

    protected AbstractTask() {
        this(AbstractTask.taskInfo());
    }

    private static TaskInfo taskInfo() {
        return nextInstance.get();
    }

    private AbstractTask(TaskInfo taskInfo) {
        if (taskInfo == null) {
            throw new TaskInstantiationException(String.format("Task of type '%s' has been instantiated directly which is not supported. Tasks can only be created using the DSL.", this.getClass().getName()));
        }
        this.project = taskInfo.project;
        this.name = taskInfo.name;
        assert (this.project != null);
        assert (this.name != null);
        this.path = this.project.absoluteProjectPath(this.name);
        this.state = new TaskStateInternal(this.toString());
        this.dependencies = new DefaultTaskDependency(this.project.getTasks());
        this.services = this.project.getServices().createFor(this);
        this.extensibleDynamicObject = new ExtensibleDynamicObject(this, (Instantiator)this.getServices().get(Instantiator.class));
        this.outputs = (TaskOutputsInternal)this.services.get(TaskOutputsInternal.class);
        this.inputs = (TaskInputs)this.services.get(TaskInputs.class);
        this.executer = (TaskExecuter)this.services.get(TaskExecuter.class);
        this.loggingManager = (LoggingManagerInternal)this.services.get(LoggingManagerInternal.class);
    }

    public static <T extends Task> T injectIntoNewInstance(ProjectInternal projectInternal, String string, Callable<T> callable) {
        nextInstance.set(new TaskInfo(projectInternal, string));
        try {
            Task task = (Task)callable.call();
            return (T)task;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            nextInstance.set(null);
        }
    }

    @Override
    public TaskState getState() {
        return this.state;
    }

    @Override
    public AntBuilder getAnt() {
        return this.project.getAnt();
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = (ProjectInternal)project;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public List<Action<? super Task>> getActions() {
        return this.actions;
    }

    @Override
    public void setActions(List<Action<? super Task>> list) {
        this.deleteAllActions();
        for (Action<? super Task> action : list) {
            this.doLast(action);
        }
    }

    @Override
    public TaskDependencyInternal getTaskDependencies() {
        return this.dependencies;
    }

    @Override
    public Set<Object> getDependsOn() {
        return this.dependencies.getValues();
    }

    @Override
    public void setDependsOn(Iterable<?> iterable) {
        this.dependencies.setValues(iterable);
    }

    @Override
    public void onlyIf(Closure closure) {
        this.onlyIfSpec = this.onlyIfSpec.and(closure);
    }

    @Override
    public void onlyIf(Spec<? super Task> spec) {
        this.onlyIfSpec = this.onlyIfSpec.and(spec);
    }

    @Override
    public void setOnlyIf(Spec<? super Task> spec) {
        this.onlyIfSpec = this.createNewOnlyIfSpec().and(spec);
    }

    @Override
    public void setOnlyIf(Closure closure) {
        this.onlyIfSpec = this.createNewOnlyIfSpec().and(closure);
    }

    private AndSpec<Task> createNewOnlyIfSpec() {
        return new AndSpec<Task>(new Spec<Task>(){

            @Override
            public boolean isSatisfiedBy(Task task) {
                return task == AbstractTask.this && AbstractTask.this.enabled;
            }
        });
    }

    @Override
    public Spec<? super TaskInternal> getOnlyIf() {
        return this.onlyIfSpec;
    }

    @Override
    public boolean getDidWork() {
        return this.state.getDidWork();
    }

    @Override
    public void setDidWork(boolean bl) {
        this.state.setDidWork(bl);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Task deleteAllActions() {
        this.actions.clear();
        return this;
    }

    @Override
    public final void execute() {
        this.executeWithoutThrowingTaskFailure();
        this.state.rethrowFailure();
    }

    @Override
    public void executeWithoutThrowingTaskFailure() {
        this.executer.execute(this, this.state);
    }

    @Override
    public TaskExecuter getExecuter() {
        return this.executer;
    }

    @Override
    public void setExecuter(TaskExecuter taskExecuter) {
        this.executer = taskExecuter;
    }

    @Override
    public Task dependsOn(Object ... objectArray) {
        this.dependencies.add(objectArray);
        return this;
    }

    @Override
    public Task doFirst(Action<? super Task> action) {
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.actions.add(0, this.wrap(action));
        return this;
    }

    @Override
    public Task doLast(Action<? super Task> action) {
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.actions.add(this.wrap(action));
        return this;
    }

    @Override
    public int compareTo(Task task) {
        int n = this.project.compareTo(task.getProject());
        if (n == 0) {
            return this.getPath().compareTo(task.getPath());
        }
        return n;
    }

    public String toString() {
        return String.format("task '%s'", this.path);
    }

    @Override
    public Logger getLogger() {
        return buildLogger;
    }

    @Override
    public LoggingManager getLogging() {
        return this.loggingManager;
    }

    @Override
    public StandardOutputCapture getStandardOutputCapture() {
        return this.loggingManager;
    }

    public DynamicObjectHelper getDynamicObjectHelper() {
        DeprecationLogger.nagUserOfReplacedMethod("AbstractTask.getDynamicObjectHelper()", "getAsDynamicObject()");
        return new DynamicObjectHelper(this.extensibleDynamicObject);
    }

    @Override
    public Object property(String string) throws MissingPropertyException {
        return this.extensibleDynamicObject.getProperty(string);
    }

    @Override
    public boolean hasProperty(String string) {
        return this.extensibleDynamicObject.hasProperty(string);
    }

    @Override
    public void setProperty(String string, Object object) {
        this.extensibleDynamicObject.setProperty(string, object);
    }

    @Override
    public Convention getConvention() {
        return this.extensibleDynamicObject.getConvention();
    }

    @Override
    public ExtensionContainer getExtensions() {
        return this.getConvention();
    }

    @Override
    public DynamicObject getAsDynamicObject() {
        return this.extensibleDynamicObject;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String string) {
        this.group = string;
    }

    @Override
    public TaskInputs getInputs() {
        return this.inputs;
    }

    @Override
    public TaskOutputsInternal getOutputs() {
        return this.outputs;
    }

    protected ServiceRegistry getServices() {
        return this.services;
    }

    @Override
    public boolean dependsOnTaskDidWork() {
        TaskDependencyInternal taskDependencyInternal = this.getTaskDependencies();
        for (Task task : taskDependencyInternal.getDependencies(this)) {
            if (!task.getDidWork()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Task doFirst(Closure closure) {
        if (closure == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.actions.add(0, this.convertClosureToAction(closure));
        return this;
    }

    @Override
    public Task doLast(Closure closure) {
        if (closure == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.actions.add(this.convertClosureToAction(closure));
        return this;
    }

    @Override
    public Task leftShift(Closure closure) {
        return this.doLast(closure);
    }

    @Override
    public Task configure(Closure closure) {
        return ConfigureUtil.configure(closure, this, false);
    }

    @Override
    public File getTemporaryDir() {
        File file = ((TemporaryFileProvider)this.getServices().get(TemporaryFileProvider.class)).newTemporaryFile(this.getName());
        file.mkdirs();
        return file;
    }

    @Override
    public Factory<File> getTemporaryDirFactory() {
        return new Factory<File>(){

            public File create() {
                return AbstractTask.this.getTemporaryDir();
            }
        };
    }

    @Override
    public void addValidator(TaskValidator taskValidator) {
        this.validators.add(taskValidator);
    }

    @Override
    public List<TaskValidator> getValidators() {
        return this.validators;
    }

    private Action<Task> convertClosureToAction(Closure closure) {
        return new ClosureTaskAction(closure);
    }

    private Action<Task> wrap(Action<? super Task> action) {
        return new TaskActionWrapper(action);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskActionWrapper
    implements Action<Task> {
        private final Action<? super Task> action;

        public TaskActionWrapper(Action<? super Task> action) {
            this.action = action;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Task task) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.action.getClass().getClassLoader());
            try {
                this.action.execute(task);
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClosureTaskAction
    implements Action<Task> {
        private final Closure closure;

        private ClosureTaskAction(Closure closure) {
            this.closure = closure;
        }

        @Override
        public void execute(Task task) {
            this.closure.setDelegate((Object)task);
            this.closure.setResolveStrategy(1);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.closure.getClass().getClassLoader());
            try {
                if (this.closure.getMaximumNumberOfParameters() == 0) {
                    this.closure.call();
                } else {
                    this.closure.call((Object)task);
                }
            }
            catch (InvokerInvocationException invokerInvocationException) {
                Throwable throwable = invokerInvocationException.getCause();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw invokerInvocationException;
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    private static class TaskInfo {
        private final ProjectInternal project;
        private final String name;

        private TaskInfo(ProjectInternal projectInternal, String string) {
            this.name = string;
            this.project = projectInternal;
        }
    }
}

