/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gradle.api.GradleException;
import org.gradle.api.internal.MultiCauseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMultiCauseException
extends GradleException
implements MultiCauseException {
    private final List<Throwable> causes = new CopyOnWriteArrayList<Throwable>();
    private final ThreadLocal<Boolean> hideCause = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public AbstractMultiCauseException(String string) {
        super(string);
    }

    public AbstractMultiCauseException(String string, Throwable ... throwableArray) {
        super(string);
        this.causes.addAll(Arrays.asList(throwableArray));
    }

    public AbstractMultiCauseException(String string, Iterable<? extends Throwable> iterable) {
        super(string);
        this.initCauses(iterable);
    }

    @Override
    public List<? extends Throwable> getCauses() {
        return this.causes;
    }

    @Override
    public Throwable initCause(Throwable throwable) {
        this.causes.clear();
        this.causes.add(throwable);
        return null;
    }

    public void initCauses(Iterable<? extends Throwable> iterable) {
        this.causes.clear();
        for (Throwable throwable : iterable) {
            this.causes.add(throwable);
        }
    }

    @Override
    public Throwable getCause() {
        if (this.hideCause.get().booleanValue()) {
            return null;
        }
        return this.causes.isEmpty() ? null : this.causes.get(0);
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream);
        this.printStackTrace(printWriter);
        printWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (this.causes.size() <= 1) {
            super.printStackTrace(printWriter);
            return;
        }
        this.hideCause.set(true);
        try {
            super.printStackTrace(printWriter);
            for (int i = 0; i < this.causes.size(); ++i) {
                Throwable throwable = this.causes.get(i);
                printWriter.format("Cause %s: ", i + 1);
                throwable.printStackTrace(printWriter);
            }
        }
        finally {
            this.hideCause.set(false);
        }
    }
}

