/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.collect.HashMultimap;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.DirectInstantiator;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.NoConventionMapping;
import org.gradle.api.internal.NoDynamicObject;
import org.gradle.api.plugins.ExtensionAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassGenerator
implements ClassGenerator {
    private static final Map<Class, Map<Class, Class>> GENERATED_CLASSES = new HashMap<Class, Map<Class, Class>>();

    public <T> T newInstance(Class<T> clazz, Object ... objectArray) {
        DirectInstantiator directInstantiator = new DirectInstantiator();
        return directInstantiator.newInstance(this.generate(clazz), objectArray);
    }

    @Override
    public <T> Class<? extends T> generate(Class<T> clazz) {
        Class<T> clazz2;
        Class clazz3;
        Map<Class, Class> map = GENERATED_CLASSES.get(this.getClass());
        if (map == null) {
            map = new HashMap<Class, Class>();
            GENERATED_CLASSES.put(this.getClass(), map);
        }
        if ((clazz3 = map.get(clazz)) != null) {
            return clazz3;
        }
        if (Modifier.isPrivate(clazz.getModifiers())) {
            throw new GradleException(String.format("Cannot create a proxy class for private class '%s'.", clazz.getSimpleName()));
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new GradleException(String.format("Cannot create a proxy class for abstract class '%s'.", clazz.getSimpleName()));
        }
        try {
            Object object2;
            Object object322;
            Object object4;
            ClassBuilder<T> classBuilder = this.start(clazz);
            boolean bl = clazz.getAnnotation(NoConventionMapping.class) == null;
            boolean bl2 = clazz.getAnnotation(NoDynamicObject.class) == null;
            classBuilder.startClass(bl, bl2);
            if (bl2 && !DynamicObjectAware.class.isAssignableFrom(clazz)) {
                if (ExtensionAware.class.isAssignableFrom(clazz)) {
                    throw new UnsupportedOperationException("A type that implements ExtensionAware must currently also implement DynamicObjectAware.");
                }
                classBuilder.mixInDynamicAware();
            }
            if (bl2 && !GroovyObject.class.isAssignableFrom(clazz)) {
                classBuilder.mixInGroovyObject();
            }
            if (bl2) {
                classBuilder.addDynamicMethods();
            }
            if (bl && !IConventionAware.class.isAssignableFrom(clazz)) {
                classBuilder.mixInConventionAware();
            }
            Class clazz4 = Object.class;
            for (object4 = clazz; object4 != null && clazz4 == Object.class; object4 = ((Class)object4).getSuperclass()) {
                if (((Class)object4).getAnnotation(NoConventionMapping.class) == null) continue;
                clazz4 = object4;
            }
            object4 = Arrays.asList("metaClass", "conventionMapping", "convention", "asDynamicObject", "extensions");
            HashSet<Object> hashSet = new HashSet<Object>();
            HashSet<Object> hashSet2 = new HashSet<Object>();
            MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(clazz);
            for (Object object322 : metaClass.getProperties()) {
                MetaMethod object5;
                if (object4.contains(object322.getName()) || !(object322 instanceof MetaBeanProperty)) continue;
                object2 = (MetaBeanProperty)object322;
                boolean bl3 = true;
                MetaMethod metaMethod2 = object2.getGetter();
                if (metaMethod2 == null) {
                    bl3 = false;
                } else if (Modifier.isFinal(metaMethod2.getModifiers()) || Modifier.isPrivate(metaMethod2.getModifiers())) {
                    bl3 = false;
                } else {
                    Class clazz5 = metaMethod2.getDeclaringClass().getTheClass();
                    if (clazz5.isAssignableFrom(clazz4)) {
                        bl3 = false;
                    }
                }
                if (bl3) {
                    hashSet2.add(object2);
                    classBuilder.addGetter((MetaBeanProperty)object2);
                }
                if ((object5 = object2.getSetter()) == null || Modifier.isPrivate(object5.getModifiers())) continue;
                if (bl3 && !Modifier.isFinal(object5.getModifiers())) {
                    classBuilder.addSetter((MetaBeanProperty)object2);
                }
                if (Iterable.class.isAssignableFrom(object322.getType())) continue;
                hashSet.add(object2);
            }
            HashMultimap hashMultimap = HashMultimap.create();
            object322 = new HashSet();
            for (MetaMethod metaMethod3 : metaClass.getMethods()) {
                if (metaMethod3.isPrivate() || metaMethod3.getParameterTypes().length != 1) continue;
                hashMultimap.put((Object)metaMethod3.getName(), (Object)metaMethod3);
                if (!metaMethod3.getParameterTypes()[0].getTheClass().equals(Action.class)) continue;
                object322.add(metaMethod3);
            }
            object2 = object322.iterator();
            while (object2.hasNext()) {
                MetaMethod metaMethod4 = (MetaMethod)object2.next();
                boolean bl4 = false;
                for (MetaMethod metaMethod : hashMultimap.get((Object)metaMethod4.getName())) {
                    if (!metaMethod.getParameterTypes()[0].getTheClass().equals(Closure.class)) continue;
                    bl4 = true;
                    break;
                }
                if (bl4) continue;
                classBuilder.addActionMethod(metaMethod4);
            }
            for (MetaBeanProperty metaBeanProperty : hashSet) {
                Collection collection = hashMultimap.get((Object)metaBeanProperty.getName());
                if (collection.isEmpty()) {
                    classBuilder.addSetMethod(metaBeanProperty);
                    continue;
                }
                if (!hashSet2.contains(metaBeanProperty)) continue;
                for (MetaMethod metaMethod : collection) {
                    classBuilder.overrideSetMethod(metaBeanProperty, metaMethod);
                }
            }
            for (Constructor<?> constructor : clazz.getConstructors()) {
                if (!Modifier.isPublic(constructor.getModifiers())) continue;
                classBuilder.addConstructor(constructor);
            }
            clazz2 = classBuilder.generate();
        }
        catch (Throwable throwable) {
            throw new GradleException(String.format("Could not generate a proxy class for class %s.", clazz.getName()), throwable);
        }
        map.put(clazz, clazz2);
        map.put(clazz2, clazz2);
        return clazz2;
    }

    protected abstract <T> ClassBuilder<T> start(Class<T> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface ClassBuilder<T> {
        public void startClass(boolean var1, boolean var2);

        public void addConstructor(Constructor<?> var1) throws Exception;

        public void mixInDynamicAware() throws Exception;

        public void mixInConventionAware() throws Exception;

        public void mixInGroovyObject() throws Exception;

        public void addDynamicMethods() throws Exception;

        public void addGetter(MetaBeanProperty var1) throws Exception;

        public void addSetter(MetaBeanProperty var1) throws Exception;

        public void overrideSetMethod(MetaBeanProperty var1, MetaMethod var2) throws Exception;

        public void addSetMethod(MetaBeanProperty var1) throws Exception;

        public Class<? extends T> generate() throws Exception;

        public void addActionMethod(MetaMethod var1) throws Exception;
    }
}

