/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import org.apache.commons.lang.StringUtils;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativePath {
    private final boolean endsWithFile;
    private final String[] segments;

    public RelativePath(boolean bl, String ... stringArray) {
        this(bl, (RelativePath)null, stringArray);
    }

    private RelativePath(boolean bl, RelativePath relativePath, String ... stringArray) {
        this.endsWithFile = bl;
        int n = 0;
        if (relativePath != null) {
            String[] stringArray2 = relativePath.getSegments();
            n = stringArray2.length;
            this.segments = new String[n + stringArray.length];
            System.arraycopy(stringArray2, 0, this.segments, 0, n);
        } else {
            this.segments = new String[stringArray.length];
        }
        System.arraycopy(stringArray, 0, this.segments, n, stringArray.length);
    }

    public String[] getSegments() {
        return this.segments;
    }

    public ListIterator<String> segmentIterator() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.segments));
        return arrayList.listIterator();
    }

    public boolean isFile() {
        return this.endsWithFile;
    }

    public String getPathString() {
        return GUtil.join(this.segments, "/");
    }

    public File getFile(File file) {
        return new File(file, this.getPathString());
    }

    public String getLastName() {
        if (this.segments.length > 0) {
            return this.segments[this.segments.length - 1];
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RelativePath relativePath = (RelativePath)object;
        if (this.endsWithFile != relativePath.endsWithFile) {
            return false;
        }
        return Arrays.equals(this.segments, relativePath.segments);
    }

    public int hashCode() {
        int n = this.endsWithFile ? 1 : 0;
        n = 31 * n + Arrays.hashCode(this.segments);
        return n;
    }

    public String toString() {
        return this.getPathString();
    }

    public RelativePath getParent() {
        if (this.segments.length == 0) {
            return null;
        }
        String[] stringArray = new String[this.segments.length - 1];
        System.arraycopy(this.segments, 0, stringArray, 0, stringArray.length);
        return new RelativePath(false, stringArray);
    }

    public static RelativePath parse(boolean bl, String string) {
        return RelativePath.parse(bl, null, string);
    }

    public static RelativePath parse(boolean bl, RelativePath relativePath, String string) {
        String[] stringArray = StringUtils.split((String)string, (String)("/" + File.separator));
        return new RelativePath(bl, relativePath, stringArray);
    }

    public RelativePath replaceLastName(String string) {
        String[] stringArray = new String[this.segments.length];
        System.arraycopy(this.segments, 0, stringArray, 0, this.segments.length);
        stringArray[this.segments.length - 1] = string;
        return new RelativePath(this.endsWithFile, stringArray);
    }

    public RelativePath append(RelativePath relativePath) {
        return new RelativePath(relativePath.endsWithFile, this, relativePath.segments);
    }

    public RelativePath plus(RelativePath relativePath) {
        return this.append(relativePath);
    }

    public RelativePath append(boolean bl, String ... stringArray) {
        return new RelativePath(bl, this, stringArray);
    }

    public RelativePath prepend(String ... stringArray) {
        return new RelativePath(false, stringArray).append(this);
    }
}

