/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.internal.SystemProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JavaVersion {
    VERSION_1_1(false),
    VERSION_1_2(false),
    VERSION_1_3(false),
    VERSION_1_4(false),
    VERSION_1_5(true),
    VERSION_1_6(true),
    VERSION_1_7(true);

    private final boolean hasMajorVersion;

    private JavaVersion(boolean bl) {
        this.hasMajorVersion = bl;
    }

    public static JavaVersion toVersion(Object object) throws IllegalArgumentException {
        int n;
        if (object == null) {
            return null;
        }
        if (object instanceof JavaVersion) {
            return (JavaVersion)((Object)object);
        }
        String string = object.toString();
        if (string.matches("\\d") && (n = Integer.parseInt(string) - 1) < JavaVersion.values().length && JavaVersion.values()[n].hasMajorVersion) {
            return JavaVersion.values()[n];
        }
        Matcher matcher = Pattern.compile("1\\.(\\d)(\\D.*)?").matcher(string);
        if (matcher.matches()) {
            return JavaVersion.values()[Integer.parseInt(matcher.group(1)) - 1];
        }
        throw new IllegalArgumentException(String.format("Could not determine java version from '%s'.", string));
    }

    public static JavaVersion current() {
        return JavaVersion.toVersion(SystemProperties.getJavaVersion());
    }

    public String toString() {
        return this.name().substring("VERSION_".length()).replace('_', '.');
    }
}

