/*
 * Decompiled with CFR 0.152.
 */
package org.gradle;

import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskState;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;

public class TaskExecutionLogger
implements TaskExecutionListener {
    private ProgressLogger currentTask;
    private final ProgressLoggerFactory progressLoggerFactory;

    public TaskExecutionLogger(ProgressLoggerFactory progressLoggerFactory) {
        this.progressLoggerFactory = progressLoggerFactory;
    }

    public void beforeExecute(Task task) {
        assert (this.currentTask == null);
        this.currentTask = this.progressLoggerFactory.newOperation(TaskExecutionLogger.class);
        String string = this.getDisplayName(task);
        this.currentTask.setDescription(String.format("Execute %s", string));
        this.currentTask.setShortDescription(string);
        this.currentTask.setLoggingHeader(string);
        this.currentTask.started();
    }

    public void afterExecute(Task task, TaskState taskState) {
        this.currentTask.completed(taskState.getSkipMessage());
        this.currentTask = null;
    }

    private String getDisplayName(Task task) {
        Gradle gradle = task.getProject().getGradle();
        if (gradle.getParent() == null) {
            return task.getPath();
        }
        return ":" + gradle.getRootProject().getName() + task.getPath();
    }
}

