/*
 * Decompiled with CFR 0.152.
 */
package org.gradle;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.gradle.CacheUsage;
import org.gradle.RefreshOptions;
import org.gradle.internal.SystemProperties;
import org.gradle.logging.LoggingConfiguration;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartParameter
extends LoggingConfiguration
implements Serializable {
    public static final String GRADLE_USER_HOME_PROPERTY_KEY = "gradle.user.home";
    public static final File DEFAULT_GRADLE_USER_HOME = new File(SystemProperties.getUserHome() + "/.gradle");
    private List<String> taskNames = new ArrayList<String>();
    private Set<String> excludedTaskNames = new HashSet<String>();
    private boolean buildProjectDependencies = true;
    private File currentDir;
    private File projectDir;
    private boolean searchUpwards = true;
    private Map<String, String> projectProperties = new HashMap<String, String>();
    private Map<String, String> systemPropertiesArgs = new HashMap<String, String>();
    private File gradleUserHomeDir;
    private CacheUsage cacheUsage = CacheUsage.ON;
    private File settingsFile;
    private boolean useEmptySettings;
    private File buildFile;
    private List<File> initScripts = new ArrayList<File>();
    private boolean dryRun;
    private boolean rerunTasks;
    private boolean profile;
    private boolean continueOnFailure;
    private boolean offline;
    private File projectCacheDir;
    private boolean refreshDependencies;
    private boolean recompileScripts;

    public void setProjectCacheDir(File file) {
        this.projectCacheDir = file;
    }

    public File getProjectCacheDir() {
        return this.projectCacheDir;
    }

    public StartParameter() {
        String string = System.getProperty(GRADLE_USER_HOME_PROPERTY_KEY);
        if (string == null && (string = System.getenv("GRADLE_USER_HOME")) == null) {
            string = DEFAULT_GRADLE_USER_HOME.getAbsolutePath();
        }
        this.gradleUserHomeDir = GFileUtils.canonicalise(new File(string));
        this.setCurrentDir(null);
    }

    public StartParameter newInstance() {
        StartParameter startParameter = new StartParameter();
        startParameter.buildFile = this.buildFile;
        startParameter.projectDir = this.projectDir;
        startParameter.settingsFile = this.settingsFile;
        startParameter.useEmptySettings = this.useEmptySettings;
        startParameter.taskNames = this.taskNames;
        startParameter.buildProjectDependencies = this.buildProjectDependencies;
        startParameter.currentDir = this.currentDir;
        startParameter.searchUpwards = this.searchUpwards;
        startParameter.projectProperties = this.projectProperties;
        startParameter.systemPropertiesArgs = this.systemPropertiesArgs;
        startParameter.gradleUserHomeDir = this.gradleUserHomeDir;
        startParameter.cacheUsage = this.cacheUsage;
        startParameter.initScripts = new ArrayList<File>(this.initScripts);
        startParameter.setLogLevel(this.getLogLevel());
        startParameter.setColorOutput(this.isColorOutput());
        startParameter.setShowStacktrace(this.getShowStacktrace());
        startParameter.dryRun = this.dryRun;
        startParameter.rerunTasks = this.rerunTasks;
        startParameter.recompileScripts = this.recompileScripts;
        startParameter.profile = this.profile;
        startParameter.projectCacheDir = this.projectCacheDir;
        startParameter.continueOnFailure = this.continueOnFailure;
        startParameter.offline = this.offline;
        startParameter.refreshDependencies = this.refreshDependencies;
        return startParameter;
    }

    public StartParameter newBuild() {
        StartParameter startParameter = new StartParameter();
        startParameter.gradleUserHomeDir = this.gradleUserHomeDir;
        startParameter.cacheUsage = this.cacheUsage;
        startParameter.setLogLevel(this.getLogLevel());
        startParameter.setColorOutput(this.isColorOutput());
        startParameter.setShowStacktrace(this.getShowStacktrace());
        startParameter.profile = this.profile;
        startParameter.continueOnFailure = this.continueOnFailure;
        startParameter.offline = this.offline;
        startParameter.rerunTasks = this.rerunTasks;
        startParameter.recompileScripts = this.recompileScripts;
        startParameter.refreshDependencies = this.refreshDependencies;
        return startParameter;
    }

    public boolean equals(Object object) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)object);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public File getBuildFile() {
        return this.buildFile;
    }

    public void setBuildFile(File file) {
        if (file == null) {
            this.buildFile = null;
            this.setCurrentDir(null);
        } else {
            this.buildFile = GFileUtils.canonicalise(file);
            this.setProjectDir(this.buildFile.getParentFile());
        }
    }

    public StartParameter useEmptySettings() {
        this.searchUpwards = false;
        this.useEmptySettings = true;
        this.settingsFile = null;
        return this;
    }

    @Deprecated
    public StartParameter useEmptySettingsScript() {
        return this.useEmptySettings();
    }

    public boolean isUseEmptySettings() {
        return this.useEmptySettings;
    }

    public List<String> getTaskNames() {
        return this.taskNames;
    }

    public void setTaskNames(Iterable<String> iterable) {
        this.taskNames = Lists.newArrayList(iterable);
    }

    public Set<String> getExcludedTaskNames() {
        return this.excludedTaskNames;
    }

    public void setExcludedTaskNames(Iterable<String> iterable) {
        this.excludedTaskNames = Sets.newLinkedHashSet(iterable);
    }

    public File getCurrentDir() {
        return this.currentDir;
    }

    public void setCurrentDir(File file) {
        this.currentDir = file != null ? GFileUtils.canonicalise(file) : GFileUtils.canonicalise(new File(System.getProperty("user.dir")));
    }

    public boolean isSearchUpwards() {
        return this.searchUpwards;
    }

    public void setSearchUpwards(boolean bl) {
        this.searchUpwards = bl;
    }

    public Map<String, String> getProjectProperties() {
        return this.projectProperties;
    }

    public void setProjectProperties(Map<String, String> map) {
        this.projectProperties = map;
    }

    public Map<String, String> getSystemPropertiesArgs() {
        return this.systemPropertiesArgs;
    }

    public void setSystemPropertiesArgs(Map<String, String> map) {
        this.systemPropertiesArgs = map;
    }

    public Map<String, String> getMergedSystemProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(System.getProperties());
        hashMap.putAll(this.getSystemPropertiesArgs());
        return hashMap;
    }

    public File getGradleUserHomeDir() {
        return this.gradleUserHomeDir;
    }

    public void setGradleUserHomeDir(File file) {
        this.gradleUserHomeDir = file == null ? DEFAULT_GRADLE_USER_HOME : GFileUtils.canonicalise(file);
    }

    public boolean isBuildProjectDependencies() {
        return this.buildProjectDependencies;
    }

    public StartParameter setBuildProjectDependencies(boolean bl) {
        this.buildProjectDependencies = bl;
        return this;
    }

    @Deprecated
    public CacheUsage getCacheUsage() {
        return this.cacheUsage;
    }

    @Deprecated
    public void setCacheUsage(CacheUsage cacheUsage) {
        this.cacheUsage = cacheUsage;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean bl) {
        this.dryRun = bl;
    }

    @Deprecated
    public boolean isNoOpt() {
        return this.rerunTasks;
    }

    @Deprecated
    public void setNoOpt(boolean bl) {
        this.rerunTasks = bl;
    }

    public void setSettingsFile(File file) {
        if (file == null) {
            this.settingsFile = null;
        } else {
            this.useEmptySettings = false;
            this.settingsFile = GFileUtils.canonicalise(file);
            this.currentDir = this.settingsFile.getParentFile();
        }
    }

    public File getSettingsFile() {
        return this.settingsFile;
    }

    public void addInitScript(File file) {
        this.initScripts.add(file);
    }

    public void setInitScripts(List<File> list) {
        this.initScripts = list;
    }

    public List<File> getInitScripts() {
        return Collections.unmodifiableList(this.initScripts);
    }

    public void setProjectDir(File file) {
        if (file == null) {
            this.setCurrentDir(null);
            this.projectDir = null;
        } else {
            File file2;
            this.currentDir = file2 = GFileUtils.canonicalise(file);
            this.projectDir = file2;
        }
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public void setProfile(boolean bl) {
        this.profile = bl;
    }

    public boolean isProfile() {
        return this.profile;
    }

    public boolean isContinueOnFailure() {
        return this.continueOnFailure;
    }

    public void setContinueOnFailure(boolean bl) {
        this.continueOnFailure = bl;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean bl) {
        this.offline = bl;
    }

    @Deprecated
    public void setRefreshOptions(RefreshOptions refreshOptions) {
        this.refreshDependencies = refreshOptions.refreshDependencies();
    }

    @Deprecated
    public RefreshOptions getRefreshOptions() {
        RefreshOptions refreshOptions = this.isRefreshDependencies() ? new RefreshOptions(Arrays.asList(RefreshOptions.Option.DEPENDENCIES)) : RefreshOptions.NONE;
        return refreshOptions;
    }

    public boolean isRefreshDependencies() {
        return this.refreshDependencies;
    }

    public void setRefreshDependencies(boolean bl) {
        this.refreshDependencies = bl;
    }

    public boolean isRerunTasks() {
        return this.rerunTasks;
    }

    public void setRerunTasks(boolean bl) {
        this.rerunTasks = bl;
    }

    public boolean isRecompileScripts() {
        return this.recompileScripts;
    }

    public void setRecompileScripts(boolean bl) {
        this.recompileScripts = bl;
    }

    public String toString() {
        return "StartParameter{taskNames=" + this.taskNames + ", excludedTaskNames=" + this.excludedTaskNames + ", currentDir=" + this.currentDir + ", searchUpwards=" + this.searchUpwards + ", projectProperties=" + this.projectProperties + ", systemPropertiesArgs=" + this.systemPropertiesArgs + ", gradleUserHomeDir=" + this.gradleUserHomeDir + ", cacheUsage=" + (Object)((Object)this.cacheUsage) + ", logLevel=" + this.getLogLevel() + ", showStacktrace=" + (Object)((Object)this.getShowStacktrace()) + ", buildFile=" + this.buildFile + ", initScripts=" + this.initScripts + ", dryRun=" + this.dryRun + ", rerunTasks=" + this.rerunTasks + ", recompileScripts=" + this.recompileScripts + ", offline=" + this.offline + ", refreshDependencies=" + this.refreshDependencies + '}';
    }
}

